/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.model.homeautomation;

import com.github.kaklakariada.fritzbox.model.homeautomation.MeasurementUnit;
import com.github.kaklakariada.fritzbox.model.homeautomation.Statistics;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractDeviceStatistics {
    public Optional<Statistics> getStatisticsByGrid(int grid) {
        return this.getStats().stream().filter(stats -> stats.getGrid() == grid).findAny();
    }

    public abstract List<Statistics> getStats();

    protected List<Statistics> getStats(List<Statistics> stats, MeasurementUnit measurementUnit) {
        return stats.stream().map(stat -> {
            stat.setMeasurementUnit(measurementUnit);
            return stat;
        }).collect(Collectors.toList());
    }

    protected abstract List<String> statisticsToString();

    protected List<String> statisticsToString(String type) {
        return this.getStats().stream().map(stats -> this.statisticsToString(type, (Statistics)stats)).collect(Collectors.toList());
    }

    private String statisticsToString(String type, Statistics statistics) {
        return String.format("[%s] count=%s,grid=%s values=[%s]", type, statistics.getCount(), statistics.getGrid(), statistics.getCsvValues());
    }
}

