/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.model.homeautomation;

import com.github.kaklakariada.fritzbox.model.homeautomation.AbstractDeviceStatistics;
import com.github.kaklakariada.fritzbox.model.homeautomation.Energy;
import com.github.kaklakariada.fritzbox.model.homeautomation.Humidity;
import com.github.kaklakariada.fritzbox.model.homeautomation.Power;
import com.github.kaklakariada.fritzbox.model.homeautomation.Temperature;
import com.github.kaklakariada.fritzbox.model.homeautomation.Voltage;
import java.util.ArrayList;
import java.util.Optional;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="devicestats")
public class DeviceStats {
    @Element(name="temperature", type=Temperature.class, required=false)
    private Temperature temperature;
    @Element(name="voltage", type=Voltage.class, required=false)
    private Voltage voltage;
    @Element(name="power", type=Power.class, required=false)
    private Power power;
    @Element(name="energy", type=Energy.class, required=false)
    private Energy energy;
    @Element(name="humidity", type=Humidity.class, required=false)
    private Humidity humidity;

    public Optional<AbstractDeviceStatistics> getTemperature() {
        return Optional.ofNullable(this.temperature);
    }

    public Optional<AbstractDeviceStatistics> getVoltage() {
        return Optional.ofNullable(this.voltage);
    }

    public Optional<AbstractDeviceStatistics> getPower() {
        return Optional.ofNullable(this.power);
    }

    public Optional<AbstractDeviceStatistics> getEnergy() {
        return Optional.ofNullable(this.energy);
    }

    public Optional<AbstractDeviceStatistics> getHumidity() {
        return Optional.ofNullable(this.humidity);
    }

    public String toString() {
        ArrayList<String> allStatistics = new ArrayList<String>();
        if (this.getTemperature().isPresent()) {
            allStatistics.addAll(this.getTemperature().get().statisticsToString());
        }
        if (this.getVoltage().isPresent()) {
            allStatistics.addAll(this.getVoltage().get().statisticsToString());
        }
        if (this.getPower().isPresent()) {
            allStatistics.addAll(this.getPower().get().statisticsToString());
        }
        if (this.getEnergy().isPresent()) {
            allStatistics.addAll(this.getEnergy().get().statisticsToString());
        }
        if (this.getHumidity().isPresent()) {
            allStatistics.addAll(this.getHumidity().get().statisticsToString());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" ---> ").append("\n\n\tStatistics").append("\n\t==========\n");
        allStatistics.forEach(stats -> sb.append("\t").append((String)stats).append("\n"));
        return sb.toString();
    }
}

