/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger LOG = LoggerFactory.getLogger(Config.class);
    private static final Path DEFAULT_CONFIG = Paths.get("application.properties", new String[0]);
    private final Properties properties;

    private Config(Properties properties) {
        this.properties = properties;
    }

    public static Config read() {
        return Config.read(DEFAULT_CONFIG);
    }

    private static Config read(Path configFile) {
        Path file = configFile.normalize();
        return new Config(Config.loadProperties(file));
    }

    private static Properties loadProperties(Path configFile) {
        Properties properties;
        block9: {
            if (!Files.exists(configFile, new LinkOption[0])) {
                throw new IllegalStateException("Config file not found at '" + configFile + "'");
            }
            LOG.info("Reading config file from {}", (Object)configFile);
            InputStream stream = Files.newInputStream(configFile, new OpenOption[0]);
            try {
                Properties props = new Properties();
                props.load(stream);
                properties = props;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error reading config file " + configFile, e);
                }
            }
            stream.close();
        }
        return properties;
    }

    public String getUrl() {
        return this.getMandatoryValue("fritzbox.url");
    }

    public String getUsername() {
        return this.getMandatoryValue("fritzbox.username");
    }

    public String getPassword() {
        return this.getMandatoryValue("fritzbox.password");
    }

    private String getMandatoryValue(String param) {
        return this.getOptionalValue(param).orElseThrow(() -> new IllegalStateException("Property '" + param + "' not found in config file"));
    }

    private Optional<String> getOptionalValue(String param) {
        return Optional.ofNullable(this.properties.getProperty(param));
    }
}

