/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox;

import com.github.kaklakariada.fritzbox.AbstractTestHelper;
import com.github.kaklakariada.fritzbox.Config;
import com.github.kaklakariada.fritzbox.HomeAutomation;
import com.github.kaklakariada.fritzbox.model.homeautomation.Device;
import com.github.kaklakariada.fritzbox.model.homeautomation.DeviceList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHkrDriver
extends AbstractTestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TestHkrDriver.class);
    private final HomeAutomation homeAutomation = HomeAutomation.connect(Config.read());

    public TestHkrDriver() {
        LOG.info("");
        LOG.info("Initial temperature");
        List<Device> hkrDevices = this.getHkrDevices();
        if (hkrDevices.isEmpty()) {
            LOG.warn("No HKR devices found");
            return;
        }
        this.showTemperatures(hkrDevices);
        String ain = hkrDevices.get(0).getIdentifier().replaceAll("\\s*", "");
        double wasTemperature = this.getCelsius(hkrDevices.get(0).getHkr().getTsoll());
        double newTsoll = 25.0;
        LOG.info("");
        LOG.info("Changing temperature of {} (ain='{}')to {} degrees", new Object[]{hkrDevices.get(0).getName(), ain, 25.0});
        this.homeAutomation.setHkrTsoll(ain, String.valueOf(this.getDegreeCode(25.0)));
        LOG.info("");
        LOG.info("Temperature after change");
        hkrDevices = this.getHkrDevices();
        this.showTemperatures(hkrDevices);
        this.homeAutomation.setHkrTsoll(ain, String.valueOf(this.getDegreeCode(wasTemperature)));
        LOG.info("");
        LOG.info("Changing back temperature of {} (ain='{}')to {} degrees", new Object[]{hkrDevices.get(0).getName(), ain, wasTemperature});
        LOG.info("");
        LOG.info("Temperature after changing back");
        hkrDevices = this.getHkrDevices();
        this.showTemperatures(hkrDevices);
    }

    private List<Device> getHkrDevices() {
        DeviceList devices = this.homeAutomation.getDeviceListInfos();
        List<Device> hkrDevices = devices.getDevices().stream().filter(device -> device.getHkr() != null).collect(Collectors.toList());
        return hkrDevices;
    }

    private void showTemperatures(List<Device> hkrDevices) {
        hkrDevices.forEach(hkr -> {
            String message = String.format("%-15s tist: %s(%s\u00b0), tsoll: %s(%s\u00b0)", hkr.getName(), hkr.getHkr().getTist(), this.getCelsius(hkr.getHkr().getTist()), hkr.getHkr().getTsoll(), this.getCelsius(hkr.getHkr().getTsoll()));
            LOG.info(message);
        });
    }

    public static void main(String[] args) {
        new TestHkrDriver();
    }
}

