/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.model.homeautomation;

import com.github.kaklakariada.fritzbox.model.homeautomation.Device;
import com.github.kaklakariada.fritzbox.model.homeautomation.Group;
import java.util.List;
import java.util.stream.Collectors;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="devicelist")
public class DeviceList {
    @Attribute(name="version")
    private String apiVersion;
    @ElementList(name="device", type=Device.class, inline=true)
    private List<Device> devices;
    @ElementList(name="group", type=Group.class, inline=true, required=false)
    private List<Group> groups;
    @Attribute(name="fwversion", required=false, empty="n/a")
    private String firmwareVersion;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public Device getDeviceByIdentifier(String identifier) {
        return this.devices.stream().filter(d -> DeviceList.identifierMatches(d, identifier)).findFirst().orElse(null);
    }

    public List<String> getDeviceIdentifiers() {
        return this.devices.stream().map(Device::getIdentifier).collect(Collectors.toList());
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    private static boolean identifierMatches(Device device, String identifier) {
        return DeviceList.normalizeIdentifier(device.getIdentifier()).equals(DeviceList.normalizeIdentifier(identifier));
    }

    private static String normalizeIdentifier(String identifier) {
        return identifier.replace(" ", "");
    }

    public Group getGroupById(String id) {
        return this.groups.stream().filter(group -> group.getId().equals(id)).findFirst().orElse(null);
    }

    public String toString() {
        return "DeviceList [apiVersion=" + this.apiVersion + ", devices=" + this.devices + "]";
    }
}

