/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.http;

import com.github.kaklakariada.fritzbox.FritzBoxException;
import com.github.kaklakariada.fritzbox.http.AccessForbiddenException;
import com.github.kaklakariada.fritzbox.http.HttpException;
import com.github.kaklakariada.fritzbox.http.NullHostnameVerifier;
import com.github.kaklakariada.fritzbox.http.NullTrustManager;
import com.github.kaklakariada.fritzbox.http.QueryParameters;
import com.github.kaklakariada.fritzbox.http.TrustSelfSignedCertificates;
import com.github.kaklakariada.fritzbox.mapping.Deserializer;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTemplate.class);
    private final OkHttpClient httpClient;
    private final HttpUrl baseUrl;
    private final Deserializer deserializer;

    public HttpTemplate(String baseUrl) {
        this(HttpTemplate.createUnsafeOkHttpClient(), new Deserializer(), HttpUrl.parse((String)baseUrl));
    }

    HttpTemplate(OkHttpClient httpClient, Deserializer deserializer, HttpUrl baseUrl) {
        this.httpClient = httpClient;
        this.deserializer = deserializer;
        this.baseUrl = baseUrl;
    }

    private static OkHttpClient createUnsafeOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.sslSocketFactory(TrustSelfSignedCertificates.getUnsafeSslSocketFactory(), (X509TrustManager)new NullTrustManager());
        builder.hostnameVerifier((HostnameVerifier)new NullHostnameVerifier());
        return builder.build();
    }

    public <T> T get(String path, Class<T> resultType) {
        return this.get(path, QueryParameters.builder().build(), resultType);
    }

    public <T> T get(String path, QueryParameters parameters, Class<T> resultType) {
        HttpUrl url = this.createUrl(path, parameters);
        return this.get(resultType, url);
    }

    public <T> T post(String path, QueryParameters parameters, Class<T> resultType) {
        HttpUrl url = this.createUrl(path, parameters);
        return this.post(resultType, url);
    }

    private <T> T get(Class<T> resultType, HttpUrl url) {
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return this.parse(response, resultType);
    }

    private <T> T post(Class<T> resultType, HttpUrl url) {
        MediaType mediaType = MediaType.parse((String)"application/xml");
        RequestBody emptyBody = RequestBody.create((byte[])new byte[0], (MediaType)mediaType);
        Request request = new Request.Builder().url(url).post(emptyBody).build();
        Response response = this.execute(request);
        return this.parse(response, resultType);
    }

    private <T> T parse(Response response, Class<T> resultType) {
        if (!response.isSuccessful()) {
            throw new FritzBoxException("Request failed: " + response);
        }
        if (response.code() == 500) {
            throw new FritzBoxException("Request failed: " + this.deserializer.getStringFromStream(response.body().byteStream()));
        }
        return this.deserializer.parse(response.body().byteStream(), resultType);
    }

    private HttpUrl createUrl(String path, QueryParameters parameters) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().encodedPath(path);
        for (Map.Entry<String, String> param : parameters.getParameters().entrySet()) {
            builder.addQueryParameter(param.getKey(), param.getValue());
        }
        return builder.build();
    }

    private Response execute(Request request) {
        LOG.trace("Executing request {}", (Object)request);
        try {
            Response response = this.httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 403) {
                    throw new AccessForbiddenException("Authentication failed, session id outdated or invalid: " + response);
                }
                throw new HttpException("Request failed with response " + response);
            }
            return response;
        }
        catch (IOException e) {
            throw new HttpException("Error executing requst " + request, e);
        }
    }
}

