/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.model.homeautomation;

import com.github.kaklakariada.fritzbox.helper.StringHelper;
import com.github.kaklakariada.fritzbox.model.homeautomation.MeasurementUnit;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

@Root(name="stats")
public class Statistics {
    private MeasurementUnit measurementUnit;
    @Attribute(name="count", required=false)
    private int count;
    @Attribute(name="grid", required=false)
    private int grid;
    @Attribute(name="datatime", required=false)
    private Long datatime;
    @Text
    private String csvValues;

    public Statistics() {
    }

    Statistics(MeasurementUnit measurementUnit, int count, int grid, Long datatime, String csvValues) {
        this.measurementUnit = measurementUnit;
        this.count = count;
        this.grid = grid;
        this.datatime = datatime;
        this.csvValues = csvValues;
    }

    public int getCount() {
        return this.count;
    }

    public int getGrid() {
        return this.grid;
    }

    public Long getDataTimeRaw() {
        return this.datatime;
    }

    public Instant getDataTime() {
        return Optional.ofNullable(this.getDataTimeRaw()).map(Instant::ofEpochSecond).orElse(null);
    }

    public String getCsvValues() {
        return this.csvValues;
    }

    void setCsvValues(String csvValues) {
        this.csvValues = csvValues;
    }

    public List<Optional<Number>> getValues() {
        if (this.getCsvValues() == null) {
            return new ArrayList<Optional<Number>>();
        }
        return Arrays.asList(this.getCsvValues().split(",")).stream().map(aValue -> Optional.ofNullable(this.computeValue((String)aValue))).collect(Collectors.toList());
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public void setMeasurementUnit(MeasurementUnit measurementUnit) {
        this.measurementUnit = measurementUnit;
    }

    protected Number computeValue(String aValue) {
        Number numberValue = null;
        if (StringHelper.isIntegerNumber(aValue)) {
            Integer intValue = Integer.valueOf(aValue.trim());
            numberValue = this.measurementUnit.getPrescision() instanceof Double ? (Number)((double)intValue.intValue() * (Double)this.measurementUnit.getPrescision()) : (Number)(intValue * (Integer)this.measurementUnit.getPrescision());
            return numberValue;
        }
        return null;
    }
}

