/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.agcod;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.agcod.model.AgcodException;
import software.amazon.awssdk.services.agcod.model.CancelGiftCardRequest;
import software.amazon.awssdk.services.agcod.model.CancelGiftCardResponse;
import software.amazon.awssdk.services.agcod.model.CreateGiftCardRequest;
import software.amazon.awssdk.services.agcod.model.CreateGiftCardResponse;
import software.amazon.awssdk.services.agcod.model.GetAvailableFundsRequest;
import software.amazon.awssdk.services.agcod.model.GetAvailableFundsResponse;
import software.amazon.awssdk.services.agcod.model.InternalServerErrorException;
import software.amazon.awssdk.services.agcod.model.PartnerAccessErrorException;
import software.amazon.awssdk.services.agcod.model.PartnerInputErrorException;
import software.amazon.awssdk.services.agcod.model.ResendErrorException;
import software.amazon.awssdk.services.agcod.model.SystemErrorException;
import software.amazon.awssdk.services.agcod.model.UnknownErrorException;

/**
 * Service client for accessing agcod. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface AgcodClient extends SdkClient {
    String SERVICE_NAME = "AGCODService";

    /**
     * Create a {@link AgcodClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AgcodClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AgcodClient}.
     */
    static AgcodClientBuilder builder() {
        return new DefaultAgcodClientBuilder();
    }

    /**
     * <p>
     * The <code>CancelGiftCardRequest</code> request cancels the Gift Card. This operation can only be executed within
     * 15 minutes of the creation request time stamp
     * </p>
     *
     * @param cancelGiftCardRequest
     *        Represents the input of a <code>CancelGiftCardRequest</code> operation.
     * @return Result of the CancelGiftCard operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.CancelGiftCard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/CancelGiftCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelGiftCardResponse cancelGiftCard(CancelGiftCardRequest cancelGiftCardRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CancelGiftCardRequest</code> request cancels the Gift Card. This operation can only be executed within
     * 15 minutes of the creation request time stamp
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelGiftCardRequest.Builder} avoiding the need to
     * create one manually via {@link CancelGiftCardRequest#builder()}
     * </p>
     *
     * @param cancelGiftCardRequest
     *        A {@link Consumer} that will call methods on {@link CancelGiftCardInput.Builder} to create a request.
     *        Represents the input of a <code>CancelGiftCardRequest</code> operation.
     * @return Result of the CancelGiftCard operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.CancelGiftCard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/CancelGiftCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelGiftCardResponse cancelGiftCard(Consumer<CancelGiftCardRequest.Builder> cancelGiftCardRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        return cancelGiftCard(CancelGiftCardRequest.builder().applyMutation(cancelGiftCardRequest).build());
    }

    /**
     * <p>
     * The <code>CreateGiftCardRequest</code> requests creates a Amazon Gift Card
     * </p>
     *
     * @param createGiftCardRequest
     *        Represents the input of a <code>CreateGiftCardRequest</code> operation.
     * @return Result of the CreateGiftCard operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.CreateGiftCard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/CreateGiftCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGiftCardResponse createGiftCard(CreateGiftCardRequest createGiftCardRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateGiftCardRequest</code> requests creates a Amazon Gift Card
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGiftCardRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGiftCardRequest#builder()}
     * </p>
     *
     * @param createGiftCardRequest
     *        A {@link Consumer} that will call methods on {@link CreateGiftCardInput.Builder} to create a request.
     *        Represents the input of a <code>CreateGiftCardRequest</code> operation.
     * @return Result of the CreateGiftCard operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.CreateGiftCard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/CreateGiftCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGiftCardResponse createGiftCard(Consumer<CreateGiftCardRequest.Builder> createGiftCardRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        return createGiftCard(CreateGiftCardRequest.builder().applyMutation(createGiftCardRequest).build());
    }

    /**
     * <p>
     * The <code>GetAvailableFundsRequest</code> returns the amount of funds currently available in your Amazon
     * Incentives account. It provides an alternative to logging into our portal for viewing available funds. A
     * potential use-case of this operation is to develop a customized alerting system or checking the balance of an
     * account periodically.
     * </p>
     *
     * @param getAvailableFundsRequest
     *        Represents the input of a <code>GetAvailableFundsRequest</code> operation.
     * @return Result of the GetAvailableFunds operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.GetAvailableFunds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/GetAvailableFunds" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAvailableFundsResponse getAvailableFunds(GetAvailableFundsRequest getAvailableFundsRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>GetAvailableFundsRequest</code> returns the amount of funds currently available in your Amazon
     * Incentives account. It provides an alternative to logging into our portal for viewing available funds. A
     * potential use-case of this operation is to develop a customized alerting system or checking the balance of an
     * account periodically.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAvailableFundsRequest.Builder} avoiding the need
     * to create one manually via {@link GetAvailableFundsRequest#builder()}
     * </p>
     *
     * @param getAvailableFundsRequest
     *        A {@link Consumer} that will call methods on {@link GetAvailableFundsInput.Builder} to create a request.
     *        Represents the input of a <code>GetAvailableFundsRequest</code> operation.
     * @return Result of the GetAvailableFunds operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.GetAvailableFunds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/GetAvailableFunds" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAvailableFundsResponse getAvailableFunds(Consumer<GetAvailableFundsRequest.Builder> getAvailableFundsRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        return getAvailableFunds(GetAvailableFundsRequest.builder().applyMutation(getAvailableFundsRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("AGCODService");
    }
}
