/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.agcod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgcodValue implements SdkPojo, Serializable, ToCopyableBuilder<AgcodValue.Builder, AgcodValue> {
    private static final SdkField<Float> AMOUNT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(AgcodValue::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AgcodValue::currencyCodeAsString)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD,
            CURRENCY_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float amount;

    private final String currencyCode;

    private AgcodValue(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * Returns the value of the Amount property for this object.
     * 
     * @return The value of the Amount property for this object.
     */
    public Float amount() {
        return amount;
    }

    /**
     * <p>
     * USD for US, EUR for EU, JPY for JP, CAD for CA, AUD for AU, TRY for TR, AED for UAE
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return USD for US, EUR for EU, JPY for JP, CAD for CA, AUD for AU, TRY for TR, AED for UAE
     * @see CurrencyCode
     */
    public CurrencyCode currencyCode() {
        return CurrencyCode.fromValue(currencyCode);
    }

    /**
     * <p>
     * USD for US, EUR for EU, JPY for JP, CAD for CA, AUD for AU, TRY for TR, AED for UAE
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return USD for US, EUR for EU, JPY for JP, CAD for CA, AUD for AU, TRY for TR, AED for UAE
     * @see CurrencyCode
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgcodValue)) {
            return false;
        }
        AgcodValue other = (AgcodValue) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AgcodValue").add("Amount", amount()).add("CurrencyCode", currencyCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgcodValue, T> g) {
        return obj -> g.apply((AgcodValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgcodValue> {
        /**
         * Sets the value of the Amount property for this object.
         *
         * @param amount
         *        The new value for the Amount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Float amount);

        /**
         * <p>
         * USD for US, EUR for EU, JPY for JP, CAD for CA, AUD for AU, TRY for TR, AED for UAE
         * </p>
         * 
         * @param currencyCode
         *        USD for US, EUR for EU, JPY for JP, CAD for CA, AUD for AU, TRY for TR, AED for UAE
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * USD for US, EUR for EU, JPY for JP, CAD for CA, AUD for AU, TRY for TR, AED for UAE
         * </p>
         * 
         * @param currencyCode
         *        USD for US, EUR for EU, JPY for JP, CAD for CA, AUD for AU, TRY for TR, AED for UAE
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(CurrencyCode currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private Float amount;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AgcodValue model) {
            amount(model.amount);
            currencyCode(model.currencyCode);
        }

        public final Float getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(Float amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Float amount) {
            this.amount = amount;
        }

        public final String getCurrencyCodeAsString() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public AgcodValue build() {
            return new AgcodValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
