/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.agcod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateGiftCardRequest</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGiftCardRequest extends AgcodRequest implements
        ToCopyableBuilder<CreateGiftCardRequest.Builder, CreateGiftCardRequest> {
    private static final SdkField<String> CREATION_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardRequest::creationRequestId)).setter(setter(Builder::creationRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationRequestId").build()).build();

    private static final SdkField<String> PARTNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardRequest::partnerId)).setter(setter(Builder::partnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerId").build()).build();

    private static final SdkField<AgcodValue> VALUE_FIELD = SdkField.<AgcodValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateGiftCardRequest::value)).setter(setter(Builder::value)).constructor(AgcodValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> PROGRAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardRequest::programId)).setter(setter(Builder::programId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programId").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardRequest::productTypeAsString)).setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productType").build()).build();

    private static final SdkField<String> EXTERNAL_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardRequest::externalReference)).setter(setter(Builder::externalReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_REQUEST_ID_FIELD,
            PARTNER_ID_FIELD, VALUE_FIELD, PROGRAM_ID_FIELD, PRODUCT_TYPE_FIELD, EXTERNAL_REFERENCE_FIELD));

    private final String creationRequestId;

    private final String partnerId;

    private final AgcodValue value;

    private final String programId;

    private final String productType;

    private final String externalReference;

    private CreateGiftCardRequest(BuilderImpl builder) {
        super(builder);
        this.creationRequestId = builder.creationRequestId;
        this.partnerId = builder.partnerId;
        this.value = builder.value;
        this.programId = builder.programId;
        this.productType = builder.productType;
        this.externalReference = builder.externalReference;
    }

    /**
     * <p>
     * A unique identifier for every CreateGiftCard call that results in the creation of a GC. The partner must generate
     * a new value for every Create request (except for retries) To keep this as the globally unique transaction
     * identifier, the partner needs to:
     * <ul>
     * <li>Generate an alphanumeric value that is unique within your system. This ID can have up to 40 alphanumeric
     * characters.</li>
     * <li>Begin the creationRequestId value with your partnerID.</li>
     * </ul>
     * </p>
     * 
     * @return A unique identifier for every CreateGiftCard call that results in the creation of a GC. The partner must
     *         generate a new value for every Create request (except for retries) To keep this as the globally unique
     *         transaction identifier, the partner needs to:
     *         <ul>
     *         <li>Generate an alphanumeric value that is unique within your system. This ID can have up to 40
     *         alphanumeric characters.</li>
     *         <li>Begin the creationRequestId value with your partnerID.</li>
     *         </ul>
     */
    public String creationRequestId() {
        return creationRequestId;
    }

    /**
     * <p>
     * A unique identifier (CASE SENSITIVE, 1st letter is capitalized and the next four are lower case) provided by the
     * Amazon GC team. This value is part of the Payload of every AGCOD Gateway request.
     * </p>
     * 
     * @return A unique identifier (CASE SENSITIVE, 1st letter is capitalized and the next four are lower case) provided
     *         by the Amazon GC team. This value is part of the Payload of every AGCOD Gateway request.
     */
    public String partnerId() {
        return partnerId;
    }

    /**
     * Returns the value of the Value property for this object.
     * 
     * @return The value of the Value property for this object.
     */
    public AgcodValue value() {
        return value;
    }

    /**
     * <p>
     * The programID is an approved identifier provided by Amazon through a submission process. The programID is
     * alphanumeric and can be up to 100 characters in length.
     * </p>
     * 
     * @return The programID is an approved identifier provided by Amazon through a submission process. The programID is
     *         alphanumeric and can be up to 100 characters in length.
     */
    public String programId() {
        return programId;
    }

    /**
     * <p>
     * The ProductType field is required for the creation of an Amazon Product Voucher Claim Code. Only authorized
     * partners can create Product Vouchers. This attribute is alpha-numeric with a max length of 50 characters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link ProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #productTypeAsString}.
     * </p>
     * 
     * @return The ProductType field is required for the creation of an Amazon Product Voucher Claim Code. Only
     *         authorized partners can create Product Vouchers. This attribute is alpha-numeric with a max length of 50
     *         characters.
     * @see ProductType
     */
    public ProductType productType() {
        return ProductType.fromValue(productType);
    }

    /**
     * <p>
     * The ProductType field is required for the creation of an Amazon Product Voucher Claim Code. Only authorized
     * partners can create Product Vouchers. This attribute is alpha-numeric with a max length of 50 characters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link ProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #productTypeAsString}.
     * </p>
     * 
     * @return The ProductType field is required for the creation of an Amazon Product Voucher Claim Code. Only
     *         authorized partners can create Product Vouchers. This attribute is alpha-numeric with a max length of 50
     *         characters.
     * @see ProductType
     */
    public String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * You can use the externalReference field to pass your own reference identifier as a string when making gift code
     * requests (up to 100 Unicode characters).
     * </p>
     * 
     * @return You can use the externalReference field to pass your own reference identifier as a string when making
     *         gift code requests (up to 100 Unicode characters).
     */
    public String externalReference() {
        return externalReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(partnerId());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(programId());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(externalReference());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGiftCardRequest)) {
            return false;
        }
        CreateGiftCardRequest other = (CreateGiftCardRequest) obj;
        return Objects.equals(creationRequestId(), other.creationRequestId()) && Objects.equals(partnerId(), other.partnerId())
                && Objects.equals(value(), other.value()) && Objects.equals(programId(), other.programId())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(externalReference(), other.externalReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGiftCardRequest").add("CreationRequestId", creationRequestId())
                .add("PartnerId", partnerId()).add("Value", value()).add("ProgramId", programId())
                .add("ProductType", productTypeAsString()).add("ExternalReference", externalReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationRequestId":
            return Optional.ofNullable(clazz.cast(creationRequestId()));
        case "partnerId":
            return Optional.ofNullable(clazz.cast(partnerId()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "programId":
            return Optional.ofNullable(clazz.cast(programId()));
        case "productType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "externalReference":
            return Optional.ofNullable(clazz.cast(externalReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGiftCardRequest, T> g) {
        return obj -> g.apply((CreateGiftCardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AgcodRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGiftCardRequest> {
        /**
         * <p>
         * A unique identifier for every CreateGiftCard call that results in the creation of a GC. The partner must
         * generate a new value for every Create request (except for retries) To keep this as the globally unique
         * transaction identifier, the partner needs to:
         * <ul>
         * <li>Generate an alphanumeric value that is unique within your system. This ID can have up to 40 alphanumeric
         * characters.</li>
         * <li>Begin the creationRequestId value with your partnerID.</li>
         * </ul>
         * </p>
         * 
         * @param creationRequestId
         *        A unique identifier for every CreateGiftCard call that results in the creation of a GC. The partner
         *        must generate a new value for every Create request (except for retries) To keep this as the globally
         *        unique transaction identifier, the partner needs to:
         *        <ul>
         *        <li>Generate an alphanumeric value that is unique within your system. This ID can have up to 40
         *        alphanumeric characters.</li>
         *        <li>Begin the creationRequestId value with your partnerID.</li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationRequestId(String creationRequestId);

        /**
         * <p>
         * A unique identifier (CASE SENSITIVE, 1st letter is capitalized and the next four are lower case) provided by
         * the Amazon GC team. This value is part of the Payload of every AGCOD Gateway request.
         * </p>
         * 
         * @param partnerId
         *        A unique identifier (CASE SENSITIVE, 1st letter is capitalized and the next four are lower case)
         *        provided by the Amazon GC team. This value is part of the Payload of every AGCOD Gateway request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerId(String partnerId);

        /**
         * Sets the value of the Value property for this object.
         *
         * @param value
         *        The new value for the Value property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(AgcodValue value);

        /**
         * Sets the value of the Value property for this object.
         *
         * This is a convenience that creates an instance of the {@link AgcodValue.Builder} avoiding the need to create
         * one manually via {@link AgcodValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgcodValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(AgcodValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link AgcodValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(AgcodValue)
         */
        default Builder value(Consumer<AgcodValue.Builder> value) {
            return value(AgcodValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The programID is an approved identifier provided by Amazon through a submission process. The programID is
         * alphanumeric and can be up to 100 characters in length.
         * </p>
         * 
         * @param programId
         *        The programID is an approved identifier provided by Amazon through a submission process. The programID
         *        is alphanumeric and can be up to 100 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programId(String programId);

        /**
         * <p>
         * The ProductType field is required for the creation of an Amazon Product Voucher Claim Code. Only authorized
         * partners can create Product Vouchers. This attribute is alpha-numeric with a max length of 50 characters.
         * </p>
         * 
         * @param productType
         *        The ProductType field is required for the creation of an Amazon Product Voucher Claim Code. Only
         *        authorized partners can create Product Vouchers. This attribute is alpha-numeric with a max length of
         *        50 characters.
         * @see ProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The ProductType field is required for the creation of an Amazon Product Voucher Claim Code. Only authorized
         * partners can create Product Vouchers. This attribute is alpha-numeric with a max length of 50 characters.
         * </p>
         * 
         * @param productType
         *        The ProductType field is required for the creation of an Amazon Product Voucher Claim Code. Only
         *        authorized partners can create Product Vouchers. This attribute is alpha-numeric with a max length of
         *        50 characters.
         * @see ProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductType
         */
        Builder productType(ProductType productType);

        /**
         * <p>
         * You can use the externalReference field to pass your own reference identifier as a string when making gift
         * code requests (up to 100 Unicode characters).
         * </p>
         * 
         * @param externalReference
         *        You can use the externalReference field to pass your own reference identifier as a string when making
         *        gift code requests (up to 100 Unicode characters).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalReference(String externalReference);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AgcodRequest.BuilderImpl implements Builder {
        private String creationRequestId;

        private String partnerId;

        private AgcodValue value;

        private String programId;

        private String productType;

        private String externalReference;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGiftCardRequest model) {
            super(model);
            creationRequestId(model.creationRequestId);
            partnerId(model.partnerId);
            value(model.value);
            programId(model.programId);
            productType(model.productType);
            externalReference(model.externalReference);
        }

        public final String getCreationRequestId() {
            return creationRequestId;
        }

        @Override
        public final Builder creationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
            return this;
        }

        public final void setCreationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
        }

        public final String getPartnerId() {
            return partnerId;
        }

        @Override
        public final Builder partnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public final void setPartnerId(String partnerId) {
            this.partnerId = partnerId;
        }

        public final AgcodValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        @Override
        public final Builder value(AgcodValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(AgcodValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final String getProgramId() {
            return programId;
        }

        @Override
        public final Builder programId(String programId) {
            this.programId = programId;
            return this;
        }

        public final void setProgramId(String programId) {
            this.programId = programId;
        }

        public final String getProductTypeAsString() {
            return productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(ProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public final String getExternalReference() {
            return externalReference;
        }

        @Override
        public final Builder externalReference(String externalReference) {
            this.externalReference = externalReference;
            return this;
        }

        public final void setExternalReference(String externalReference) {
            this.externalReference = externalReference;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGiftCardRequest build() {
            return new CreateGiftCardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
