/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.agcod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>CreateGiftCard</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGiftCardResponse extends AgcodResponse implements
        ToCopyableBuilder<CreateGiftCardResponse.Builder, CreateGiftCardResponse> {
    private static final SdkField<String> CARD_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardResponse::cardNumber)).setter(setter(Builder::cardNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardNumber").build()).build();

    private static final SdkField<String> CARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardResponse::cardStatus)).setter(setter(Builder::cardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardStatus").build()).build();

    private static final SdkField<String> EXPIRATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardResponse::expirationDate)).setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()).build();

    private static final SdkField<AgcodValue> VALUE_FIELD = SdkField.<AgcodValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateGiftCardResponse::value)).setter(setter(Builder::value)).constructor(AgcodValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> CREATION_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardResponse::creationRequestId)).setter(setter(Builder::creationRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationRequestId").build()).build();

    private static final SdkField<String> GC_CLAIM_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardResponse::gcClaimCode)).setter(setter(Builder::gcClaimCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gcClaimCode").build()).build();

    private static final SdkField<String> GC_EXPIRATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardResponse::gcExpirationDate)).setter(setter(Builder::gcExpirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gcExpirationDate").build()).build();

    private static final SdkField<String> GC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardResponse::gcId)).setter(setter(Builder::gcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gcId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGiftCardResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_NUMBER_FIELD,
            CARD_STATUS_FIELD, EXPIRATION_DATE_FIELD, VALUE_FIELD, CREATION_REQUEST_ID_FIELD, GC_CLAIM_CODE_FIELD,
            GC_EXPIRATION_DATE_FIELD, GC_ID_FIELD, STATUS_FIELD));

    private final String cardNumber;

    private final String cardStatus;

    private final String expirationDate;

    private final AgcodValue value;

    private final String creationRequestId;

    private final String gcClaimCode;

    private final String gcExpirationDate;

    private final String gcId;

    private final String status;

    private CreateGiftCardResponse(BuilderImpl builder) {
        super(builder);
        this.cardNumber = builder.cardNumber;
        this.cardStatus = builder.cardStatus;
        this.expirationDate = builder.expirationDate;
        this.value = builder.value;
        this.creationRequestId = builder.creationRequestId;
        this.gcClaimCode = builder.gcClaimCode;
        this.gcExpirationDate = builder.gcExpirationDate;
        this.gcId = builder.gcId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public String cardNumber() {
        return cardNumber;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public String cardStatus() {
        return cardStatus;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public String expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public AgcodValue value() {
        return value;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public String creationRequestId() {
        return creationRequestId;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public String gcClaimCode() {
        return gcClaimCode;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public String gcExpirationDate() {
        return gcExpirationDate;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public String gcId() {
        return gcId;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgcodResponseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Docu goes here.
     * @see AgcodResponseStatus
     */
    public AgcodResponseStatus status() {
        return AgcodResponseStatus.fromValue(status);
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgcodResponseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Docu goes here.
     * @see AgcodResponseStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cardNumber());
        hashCode = 31 * hashCode + Objects.hashCode(cardStatus());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(creationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(gcClaimCode());
        hashCode = 31 * hashCode + Objects.hashCode(gcExpirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(gcId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGiftCardResponse)) {
            return false;
        }
        CreateGiftCardResponse other = (CreateGiftCardResponse) obj;
        return Objects.equals(cardNumber(), other.cardNumber()) && Objects.equals(cardStatus(), other.cardStatus())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(value(), other.value())
                && Objects.equals(creationRequestId(), other.creationRequestId())
                && Objects.equals(gcClaimCode(), other.gcClaimCode())
                && Objects.equals(gcExpirationDate(), other.gcExpirationDate()) && Objects.equals(gcId(), other.gcId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGiftCardResponse").add("CardNumber", cardNumber()).add("CardStatus", cardStatus())
                .add("ExpirationDate", expirationDate()).add("Value", value()).add("CreationRequestId", creationRequestId())
                .add("GcClaimCode", gcClaimCode()).add("GcExpirationDate", gcExpirationDate()).add("GcId", gcId())
                .add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cardNumber":
            return Optional.ofNullable(clazz.cast(cardNumber()));
        case "cardStatus":
            return Optional.ofNullable(clazz.cast(cardStatus()));
        case "expirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "creationRequestId":
            return Optional.ofNullable(clazz.cast(creationRequestId()));
        case "gcClaimCode":
            return Optional.ofNullable(clazz.cast(gcClaimCode()));
        case "gcExpirationDate":
            return Optional.ofNullable(clazz.cast(gcExpirationDate()));
        case "gcId":
            return Optional.ofNullable(clazz.cast(gcId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGiftCardResponse, T> g) {
        return obj -> g.apply((CreateGiftCardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AgcodResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGiftCardResponse> {
        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param cardNumber
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardNumber(String cardNumber);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param cardStatus
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardStatus(String cardStatus);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param expirationDate
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(String expirationDate);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param value
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(AgcodValue value);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * This is a convenience that creates an instance of the {@link AgcodValue.Builder} avoiding the need to create
         * one manually via {@link AgcodValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgcodValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(AgcodValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link AgcodValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(AgcodValue)
         */
        default Builder value(Consumer<AgcodValue.Builder> value) {
            return value(AgcodValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param creationRequestId
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationRequestId(String creationRequestId);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param gcClaimCode
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcClaimCode(String gcClaimCode);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param gcExpirationDate
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcExpirationDate(String gcExpirationDate);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param gcId
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcId(String gcId);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param status
         *        Docu goes here.
         * @see AgcodResponseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgcodResponseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param status
         *        Docu goes here.
         * @see AgcodResponseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgcodResponseStatus
         */
        Builder status(AgcodResponseStatus status);
    }

    static final class BuilderImpl extends AgcodResponse.BuilderImpl implements Builder {
        private String cardNumber;

        private String cardStatus;

        private String expirationDate;

        private AgcodValue value;

        private String creationRequestId;

        private String gcClaimCode;

        private String gcExpirationDate;

        private String gcId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGiftCardResponse model) {
            super(model);
            cardNumber(model.cardNumber);
            cardStatus(model.cardStatus);
            expirationDate(model.expirationDate);
            value(model.value);
            creationRequestId(model.creationRequestId);
            gcClaimCode(model.gcClaimCode);
            gcExpirationDate(model.gcExpirationDate);
            gcId(model.gcId);
            status(model.status);
        }

        public final String getCardNumber() {
            return cardNumber;
        }

        @Override
        public final Builder cardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
            return this;
        }

        public final void setCardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
        }

        public final String getCardStatus() {
            return cardStatus;
        }

        @Override
        public final Builder cardStatus(String cardStatus) {
            this.cardStatus = cardStatus;
            return this;
        }

        public final void setCardStatus(String cardStatus) {
            this.cardStatus = cardStatus;
        }

        public final String getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final AgcodValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        @Override
        public final Builder value(AgcodValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(AgcodValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final String getCreationRequestId() {
            return creationRequestId;
        }

        @Override
        public final Builder creationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
            return this;
        }

        public final void setCreationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
        }

        public final String getGcClaimCode() {
            return gcClaimCode;
        }

        @Override
        public final Builder gcClaimCode(String gcClaimCode) {
            this.gcClaimCode = gcClaimCode;
            return this;
        }

        public final void setGcClaimCode(String gcClaimCode) {
            this.gcClaimCode = gcClaimCode;
        }

        public final String getGcExpirationDate() {
            return gcExpirationDate;
        }

        @Override
        public final Builder gcExpirationDate(String gcExpirationDate) {
            this.gcExpirationDate = gcExpirationDate;
            return this;
        }

        public final void setGcExpirationDate(String gcExpirationDate) {
            this.gcExpirationDate = gcExpirationDate;
        }

        public final String getGcId() {
            return gcId;
        }

        @Override
        public final Builder gcId(String gcId) {
            this.gcId = gcId;
            return this;
        }

        public final void setGcId(String gcId) {
            this.gcId = gcId;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgcodResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public CreateGiftCardResponse build() {
            return new CreateGiftCardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
