/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.agcod.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAvailableFundsResponse extends AgcodResponse implements
        ToCopyableBuilder<GetAvailableFundsResponse.Builder, GetAvailableFundsResponse> {
    private static final SdkField<AgcodValue> AVAILABLE_FUNDS_FIELD = SdkField.<AgcodValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetAvailableFundsResponse::availableFunds)).setter(setter(Builder::availableFunds))
            .constructor(AgcodValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableFunds").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetAvailableFundsResponse::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAvailableFundsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_FUNDS_FIELD,
            TIMESTAMP_FIELD, STATUS_FIELD));

    private final AgcodValue availableFunds;

    private final Instant timestamp;

    private final String status;

    private GetAvailableFundsResponse(BuilderImpl builder) {
        super(builder);
        this.availableFunds = builder.availableFunds;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public AgcodValue availableFunds() {
        return availableFunds;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * 
     * @return Docu goes here.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgcodResponseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Docu goes here.
     * @see AgcodResponseStatus
     */
    public AgcodResponseStatus status() {
        return AgcodResponseStatus.fromValue(status);
    }

    /**
     * <p>
     * Docu goes here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgcodResponseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Docu goes here.
     * @see AgcodResponseStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availableFunds());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAvailableFundsResponse)) {
            return false;
        }
        GetAvailableFundsResponse other = (GetAvailableFundsResponse) obj;
        return Objects.equals(availableFunds(), other.availableFunds()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAvailableFundsResponse").add("AvailableFunds", availableFunds())
                .add("Timestamp", timestamp()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "availableFunds":
            return Optional.ofNullable(clazz.cast(availableFunds()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAvailableFundsResponse, T> g) {
        return obj -> g.apply((GetAvailableFundsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AgcodResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAvailableFundsResponse> {
        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param availableFunds
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableFunds(AgcodValue availableFunds);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * This is a convenience that creates an instance of the {@link AgcodValue.Builder} avoiding the need to create
         * one manually via {@link AgcodValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgcodValue.Builder#build()} is called immediately and its result
         * is passed to {@link #availableFunds(AgcodValue)}.
         * 
         * @param availableFunds
         *        a consumer that will call methods on {@link AgcodValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availableFunds(AgcodValue)
         */
        default Builder availableFunds(Consumer<AgcodValue.Builder> availableFunds) {
            return availableFunds(AgcodValue.builder().applyMutation(availableFunds).build());
        }

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param timestamp
         *        Docu goes here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param status
         *        Docu goes here.
         * @see AgcodResponseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgcodResponseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Docu goes here.
         * </p>
         * 
         * @param status
         *        Docu goes here.
         * @see AgcodResponseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgcodResponseStatus
         */
        Builder status(AgcodResponseStatus status);
    }

    static final class BuilderImpl extends AgcodResponse.BuilderImpl implements Builder {
        private AgcodValue availableFunds;

        private Instant timestamp;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAvailableFundsResponse model) {
            super(model);
            availableFunds(model.availableFunds);
            timestamp(model.timestamp);
            status(model.status);
        }

        public final AgcodValue.Builder getAvailableFunds() {
            return availableFunds != null ? availableFunds.toBuilder() : null;
        }

        @Override
        public final Builder availableFunds(AgcodValue availableFunds) {
            this.availableFunds = availableFunds;
            return this;
        }

        public final void setAvailableFunds(AgcodValue.BuilderImpl availableFunds) {
            this.availableFunds = availableFunds != null ? availableFunds.build() : null;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgcodResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetAvailableFundsResponse build() {
            return new GetAvailableFundsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
