/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.agcod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * F100: System Errors
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemErrorException extends AgcodException implements
        ToCopyableBuilder<SystemErrorException.Builder, SystemErrorException> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SystemErrorException::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SystemErrorException::errorType)).setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();

    private static final SdkField<GiftCardResponse> AGCOD_RESPONSE_FIELD = SdkField
            .<GiftCardResponse> builder(MarshallingType.SDK_POJO).getter(getter(SystemErrorException::agcodResponse))
            .setter(setter(Builder::agcodResponse)).constructor(GiftCardResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agcodResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_TYPE_FIELD, AGCOD_RESPONSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorType;

    private final GiftCardResponse agcodResponse;

    private SystemErrorException(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
        this.errorType = builder.errorType;
        this.agcodResponse = builder.agcodResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ErrorCode property for this object.
     * 
     * @return The value of the ErrorCode property for this object.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * Returns the value of the ErrorType property for this object.
     * 
     * @return The value of the ErrorType property for this object.
     */
    public String errorType() {
        return errorType;
    }

    /**
     * Returns the value of the AgcodResponse property for this object.
     * 
     * @return The value of the AgcodResponse property for this object.
     */
    public GiftCardResponse agcodResponse() {
        return agcodResponse;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemErrorException, T> g) {
        return obj -> g.apply((SystemErrorException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemErrorException>, AgcodException.Builder {
        /**
         * Sets the value of the ErrorCode property for this object.
         *
         * @param errorCode
         *        The new value for the ErrorCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * Sets the value of the ErrorType property for this object.
         *
         * @param errorType
         *        The new value for the ErrorType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorType(String errorType);

        /**
         * Sets the value of the AgcodResponse property for this object.
         *
         * @param agcodResponse
         *        The new value for the AgcodResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agcodResponse(GiftCardResponse agcodResponse);

        /**
         * Sets the value of the AgcodResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link GiftCardResponse.Builder} avoiding the need to
         * create one manually via {@link GiftCardResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link GiftCardResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #agcodResponse(GiftCardResponse)}.
         * 
         * @param agcodResponse
         *        a consumer that will call methods on {@link GiftCardResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agcodResponse(GiftCardResponse)
         */
        default Builder agcodResponse(Consumer<GiftCardResponse.Builder> agcodResponse) {
            return agcodResponse(GiftCardResponse.builder().applyMutation(agcodResponse).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends AgcodException.BuilderImpl implements Builder {
        private String errorCode;

        private String errorType;

        private GiftCardResponse agcodResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemErrorException model) {
            super(model);
            errorCode(model.errorCode);
            errorType(model.errorType);
            agcodResponse(model.agcodResponse);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorType() {
            return errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        public final GiftCardResponse.Builder getAgcodResponse() {
            return agcodResponse != null ? agcodResponse.toBuilder() : null;
        }

        @Override
        public final Builder agcodResponse(GiftCardResponse agcodResponse) {
            this.agcodResponse = agcodResponse;
            return this;
        }

        public final void setAgcodResponse(GiftCardResponse.BuilderImpl agcodResponse) {
            this.agcodResponse = agcodResponse != null ? agcodResponse.build() : null;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public SystemErrorException build() {
            return new SystemErrorException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
