/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.agcod;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnExceptionsCondition;
import software.amazon.awssdk.services.agcod.model.ResendErrorException;

@SdkProtectedApi
public final class AgcodRetryPolicy {
    private static final int DEFAULT_MAX_ERROR_RETRY = 8;
    private static final Duration DEFAULT_BASE_DELAY = Duration.ofMillis(100L);
    private static final Set<Class<? extends Exception>> RETRYABLE_EXCEPTIONS = Collections.singleton(ResendErrorException.class);
    private static final BackoffStrategy DEFAULT_BACKOFF_STRATEGY = FullJitterBackoffStrategy.builder().baseDelay(DEFAULT_BASE_DELAY).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build();
    private static final RetryPolicy DEFAULT = AwsRetryPolicy.defaultRetryPolicy().toBuilder().numRetries(Integer.valueOf(8)).retryCondition((RetryCondition)OrRetryCondition.create((RetryCondition[])new RetryCondition[]{RetryCondition.defaultRetryCondition(), RetryOnExceptionsCondition.create(RETRYABLE_EXCEPTIONS)})).backoffStrategy(DEFAULT_BACKOFF_STRATEGY).build();

    private AgcodRetryPolicy() {
    }

    public static RetryPolicy defaultPolicy() {
        return DEFAULT;
    }
}

