/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.agcod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.agcod.model.AgcodResponse;
import software.amazon.awssdk.services.agcod.model.AgcodResponseStatus;
import software.amazon.awssdk.services.agcod.model.AgcodValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGiftCardResponse
extends AgcodResponse
implements ToCopyableBuilder<Builder, CreateGiftCardResponse> {
    private static final SdkField<String> CARD_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::cardNumber)).setter(CreateGiftCardResponse.setter(Builder::cardNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardNumber").build()}).build();
    private static final SdkField<String> CARD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::cardStatus)).setter(CreateGiftCardResponse.setter(Builder::cardStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardStatus").build()}).build();
    private static final SdkField<String> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::expirationDate)).setter(CreateGiftCardResponse.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()}).build();
    private static final SdkField<AgcodValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::value)).setter(CreateGiftCardResponse.setter(Builder::value)).constructor(AgcodValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> CREATION_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::creationRequestId)).setter(CreateGiftCardResponse.setter(Builder::creationRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationRequestId").build()}).build();
    private static final SdkField<String> GC_CLAIM_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::gcClaimCode)).setter(CreateGiftCardResponse.setter(Builder::gcClaimCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gcClaimCode").build()}).build();
    private static final SdkField<String> GC_EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::gcExpirationDate)).setter(CreateGiftCardResponse.setter(Builder::gcExpirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gcExpirationDate").build()}).build();
    private static final SdkField<String> GC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::gcId)).setter(CreateGiftCardResponse.setter(Builder::gcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gcId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardResponse.getter(CreateGiftCardResponse::statusAsString)).setter(CreateGiftCardResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_NUMBER_FIELD, CARD_STATUS_FIELD, EXPIRATION_DATE_FIELD, VALUE_FIELD, CREATION_REQUEST_ID_FIELD, GC_CLAIM_CODE_FIELD, GC_EXPIRATION_DATE_FIELD, GC_ID_FIELD, STATUS_FIELD));
    private final String cardNumber;
    private final String cardStatus;
    private final String expirationDate;
    private final AgcodValue value;
    private final String creationRequestId;
    private final String gcClaimCode;
    private final String gcExpirationDate;
    private final String gcId;
    private final String status;

    private CreateGiftCardResponse(BuilderImpl builder) {
        super(builder);
        this.cardNumber = builder.cardNumber;
        this.cardStatus = builder.cardStatus;
        this.expirationDate = builder.expirationDate;
        this.value = builder.value;
        this.creationRequestId = builder.creationRequestId;
        this.gcClaimCode = builder.gcClaimCode;
        this.gcExpirationDate = builder.gcExpirationDate;
        this.gcId = builder.gcId;
        this.status = builder.status;
    }

    public String cardNumber() {
        return this.cardNumber;
    }

    public String cardStatus() {
        return this.cardStatus;
    }

    public String expirationDate() {
        return this.expirationDate;
    }

    public AgcodValue value() {
        return this.value;
    }

    public String creationRequestId() {
        return this.creationRequestId;
    }

    public String gcClaimCode() {
        return this.gcClaimCode;
    }

    public String gcExpirationDate() {
        return this.gcExpirationDate;
    }

    public String gcId() {
        return this.gcId;
    }

    public AgcodResponseStatus status() {
        return AgcodResponseStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cardNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.cardStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcClaimCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcExpirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGiftCardResponse)) {
            return false;
        }
        CreateGiftCardResponse other = (CreateGiftCardResponse)((Object)obj);
        return Objects.equals(this.cardNumber(), other.cardNumber()) && Objects.equals(this.cardStatus(), other.cardStatus()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.creationRequestId(), other.creationRequestId()) && Objects.equals(this.gcClaimCode(), other.gcClaimCode()) && Objects.equals(this.gcExpirationDate(), other.gcExpirationDate()) && Objects.equals(this.gcId(), other.gcId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateGiftCardResponse").add("CardNumber", (Object)this.cardNumber()).add("CardStatus", (Object)this.cardStatus()).add("ExpirationDate", (Object)this.expirationDate()).add("Value", (Object)this.value()).add("CreationRequestId", (Object)this.creationRequestId()).add("GcClaimCode", (Object)this.gcClaimCode()).add("GcExpirationDate", (Object)this.gcExpirationDate()).add("GcId", (Object)this.gcId()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cardNumber": {
                return Optional.ofNullable(clazz.cast(this.cardNumber()));
            }
            case "cardStatus": {
                return Optional.ofNullable(clazz.cast(this.cardStatus()));
            }
            case "expirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "creationRequestId": {
                return Optional.ofNullable(clazz.cast(this.creationRequestId()));
            }
            case "gcClaimCode": {
                return Optional.ofNullable(clazz.cast(this.gcClaimCode()));
            }
            case "gcExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.gcExpirationDate()));
            }
            case "gcId": {
                return Optional.ofNullable(clazz.cast(this.gcId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGiftCardResponse, T> g) {
        return obj -> g.apply((CreateGiftCardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AgcodResponse.BuilderImpl
    implements Builder {
        private String cardNumber;
        private String cardStatus;
        private String expirationDate;
        private AgcodValue value;
        private String creationRequestId;
        private String gcClaimCode;
        private String gcExpirationDate;
        private String gcId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGiftCardResponse model) {
            super(model);
            this.cardNumber(model.cardNumber);
            this.cardStatus(model.cardStatus);
            this.expirationDate(model.expirationDate);
            this.value(model.value);
            this.creationRequestId(model.creationRequestId);
            this.gcClaimCode(model.gcClaimCode);
            this.gcExpirationDate(model.gcExpirationDate);
            this.gcId(model.gcId);
            this.status(model.status);
        }

        public final String getCardNumber() {
            return this.cardNumber;
        }

        @Override
        public final Builder cardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
            return this;
        }

        public final void setCardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
        }

        public final String getCardStatus() {
            return this.cardStatus;
        }

        @Override
        public final Builder cardStatus(String cardStatus) {
            this.cardStatus = cardStatus;
            return this;
        }

        public final void setCardStatus(String cardStatus) {
            this.cardStatus = cardStatus;
        }

        public final String getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final AgcodValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(AgcodValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(AgcodValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final String getCreationRequestId() {
            return this.creationRequestId;
        }

        @Override
        public final Builder creationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
            return this;
        }

        public final void setCreationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
        }

        public final String getGcClaimCode() {
            return this.gcClaimCode;
        }

        @Override
        public final Builder gcClaimCode(String gcClaimCode) {
            this.gcClaimCode = gcClaimCode;
            return this;
        }

        public final void setGcClaimCode(String gcClaimCode) {
            this.gcClaimCode = gcClaimCode;
        }

        public final String getGcExpirationDate() {
            return this.gcExpirationDate;
        }

        @Override
        public final Builder gcExpirationDate(String gcExpirationDate) {
            this.gcExpirationDate = gcExpirationDate;
            return this;
        }

        public final void setGcExpirationDate(String gcExpirationDate) {
            this.gcExpirationDate = gcExpirationDate;
        }

        public final String getGcId() {
            return this.gcId;
        }

        @Override
        public final Builder gcId(String gcId) {
            this.gcId = gcId;
            return this;
        }

        public final void setGcId(String gcId) {
            this.gcId = gcId;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgcodResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public CreateGiftCardResponse build() {
            return new CreateGiftCardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AgcodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGiftCardResponse> {
        public Builder cardNumber(String var1);

        public Builder cardStatus(String var1);

        public Builder expirationDate(String var1);

        public Builder value(AgcodValue var1);

        default public Builder value(Consumer<AgcodValue.Builder> value) {
            return this.value((AgcodValue)((AgcodValue.Builder)AgcodValue.builder().applyMutation(value)).build());
        }

        public Builder creationRequestId(String var1);

        public Builder gcClaimCode(String var1);

        public Builder gcExpirationDate(String var1);

        public Builder gcId(String var1);

        public Builder status(String var1);

        public Builder status(AgcodResponseStatus var1);
    }
}

