/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.agcod.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CurrencyCode {
    USD("USD"),
    EUR("EUR"),
    GBP("GBP"),
    JPY("JPY"),
    CNY("CNY"),
    CAD("CAD"),
    AED("AED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CurrencyCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CurrencyCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CurrencyCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CurrencyCode> knownValues() {
        return Stream.of(CurrencyCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

