/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import com.github.libxjava.io.ISerialisable;
import com.github.libxjava.util.BasicHashMap;

final class BinarySerialiserConstants {
    public static final byte NULL = 1;
    public static final byte REFERENCE = 2;
    public static final byte SERIALISABLE = 3;
    public static final byte BASE_TYPE_START = 4;
    public static final byte BOOLEAN = 4;
    public static final byte BYTE = 5;
    public static final byte CHAR = 6;
    public static final byte DOUBLE = 7;
    public static final byte FLOAT = 8;
    public static final byte INT = 9;
    public static final byte LONG = 10;
    public static final byte SHORT = 11;
    public static final byte STRING = 12;
    private static final BasicHashMap ALLOWED = new BasicHashMap();

    public static byte getType(String className) {
        if (BinarySerialiserConstants.containsType(className)) {
            return (Byte)ALLOWED.get(className);
        }
        return -1;
    }

    public static boolean containsType(String className) {
        return ALLOWED.containsKey(className);
    }

    public static boolean isSerialisationSupported(Object obj) {
        if (obj == null || obj instanceof ISerialisable) {
            return true;
        }
        return BinarySerialiserConstants.containsType(obj.getClass().getName());
    }

    private BinarySerialiserConstants() {
    }

    static {
        ALLOWED.put("java.lang.Boolean", new Byte(4));
        ALLOWED.put("java.lang.Byte", new Byte(5));
        ALLOWED.put("java.lang.Character", new Byte(6));
        ALLOWED.put("java.lang.Double", new Byte(7));
        ALLOWED.put("java.lang.Float", new Byte(8));
        ALLOWED.put("java.lang.Integer", new Byte(9));
        ALLOWED.put("java.lang.Long", new Byte(10));
        ALLOWED.put("java.lang.Short", new Byte(11));
        ALLOWED.put("java.lang.String", new Byte(12));
    }
}

