/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import java.io.IOException;
import java.io.InputStream;

public abstract class BufferedInputStream
extends InputStream {
    protected final int bufsize;
    private byte[] _buffer;
    private int _position = 0;
    private int _count = 0;
    protected final Object worklock = new Object();

    protected BufferedInputStream(int bufsize) {
        this.bufsize = bufsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int available() {
        Object object = this.worklock;
        synchronized (object) {
            return this._count - this._position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.worklock;
        synchronized (object) {
            this._buffer = null;
            this._position = 0;
            this._count = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read() throws IOException {
        Object object = this.worklock;
        synchronized (object) {
            boolean eof = this.checkBuffer();
            return eof ? -1 : this._buffer[this._position++] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("offset and/or length are out of the buffers bounds");
        }
        Object object = this.worklock;
        synchronized (object) {
            if (this.checkBuffer()) {
                return -1;
            }
            int numBytes = 0;
            int canRead = this._count - this._position;
            if (canRead > 0 && len > 0) {
                numBytes = len > canRead ? canRead : len;
                System.arraycopy(this._buffer, this._position, b, off, numBytes);
                this._position += numBytes;
            }
            return numBytes;
        }
    }

    protected int getPayloadStart() {
        return 0;
    }

    protected int getPayloadEnd() {
        return this.bufsize;
    }

    protected abstract int internalRead(byte[] var1) throws IOException;

    private boolean checkBuffer() throws IOException {
        if (this._buffer == null) {
            this._buffer = new byte[this.bufsize];
        }
        if (this._count - this._position == 0) {
            int numBytes = this.internalRead(this._buffer);
            if (numBytes <= 0) {
                this._count = 0;
                this._buffer = null;
            } else {
                this._count = numBytes;
            }
            this._position = 0;
            if (numBytes == 0) {
                throw new IOException("internalRead");
            }
            return numBytes == -1;
        }
        return false;
    }
}

