/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import java.io.InputStream;

public final class ByteArrayInputBuffer
extends InputStream {
    private byte[] _buffer;
    private int _position;
    private int _count;
    private int _mark;

    public ByteArrayInputBuffer() {
        this(new byte[0]);
    }

    public ByteArrayInputBuffer(byte[] buffer) {
        this._buffer = buffer;
        this._count = this._buffer.length;
        this._position = 0;
    }

    public int available() {
        return this._count - this._position;
    }

    public void close() {
    }

    public byte[] getByteArrayReference() {
        return this._buffer;
    }

    public void mark(int readlimit) {
        this._mark = this._position;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() {
        return this._position < this._count ? this._buffer[this._position++] & 0xFF : -1;
    }

    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new IllegalArgumentException("null buffer");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this._position >= this._count) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        int max = this._count - this._position;
        if (len > max) {
            len = max;
        }
        System.arraycopy(this._buffer, this._position, b, off, len);
        this._position += len;
        return len;
    }

    public void reset() {
        this._position = this._mark;
    }

    public void setInput(byte[] input) {
        this.setInput(input, 0, input.length);
    }

    public void setInput(byte[] input, int off, int len) {
        this._buffer = input;
        this._position = off;
        this._count = len;
        this._mark = 0;
    }

    public long skip(long n) {
        if (n < 0L) {
            return 0L;
        }
        if ((long)this._position + n > (long)this._count) {
            n = this._count - this._position;
        }
        this._position = (int)((long)this._position + n);
        return n;
    }
}

