/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import com.github.libxjava.io.BaseX;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64
extends BaseX {
    private static final byte FILL = 61;
    private static final byte[] STANDARD_ENCODABET;
    private static final byte[] STANDARD_DECODABET;
    private final byte[] _decodedBuffer = new byte[60];
    private final byte[] _encodedBuffer = new byte[80];

    protected void internalDecode(InputStream in, OutputStream out) throws IOException {
        int encOff = 0;
        int encLen = this._encodedBuffer.length;
        int numBytes = 0;
        do {
            if ((numBytes = in.read(this._encodedBuffer, encOff, encLen)) >= 0) {
                encOff += numBytes;
                if ((encLen -= numBytes) > 0) continue;
            }
            if (encOff > 0) {
                int i = 0;
                int decIndex = 0;
                while (i < encOff) {
                    byte first = (byte)(STANDARD_DECODABET[this._encodedBuffer[i++]] & 0x3F);
                    byte second = (byte)(STANDARD_DECODABET[this._encodedBuffer[i++]] & 0x3F);
                    this._decodedBuffer[decIndex++] = (byte)((first << 2 | second >>> 4 & 0x3F) & 0xFF);
                    first = second;
                    if (this._encodedBuffer[i] == 61) {
                        out.write(this._decodedBuffer, 0, decIndex);
                        return;
                    }
                    second = (byte)(STANDARD_DECODABET[this._encodedBuffer[i++]] & 0x3F);
                    this._decodedBuffer[decIndex++] = (byte)((first << 4 | second >>> 2 & 0x3F) & 0xFF);
                    first = second;
                    if (this._encodedBuffer[i] == 61) {
                        out.write(this._decodedBuffer, 0, decIndex);
                        return;
                    }
                    second = (byte)(STANDARD_DECODABET[this._encodedBuffer[i++]] & 0x3F);
                    this._decodedBuffer[decIndex++] = (byte)((first << 6 | second & 0x3F) & 0xFF);
                }
                out.write(this._decodedBuffer, 0, decIndex);
            }
            encOff = 0;
            encLen = this._encodedBuffer.length;
        } while (numBytes >= 0);
    }

    protected void internalEncode(InputStream in, OutputStream out) throws IOException {
        int decOff = 0;
        int decLen = this._decodedBuffer.length;
        int numBytes = 0;
        do {
            if ((numBytes = in.read(this._decodedBuffer, decOff, decLen)) >= 0) {
                decOff += numBytes;
                if ((decLen -= numBytes) > 0) continue;
            }
            if (decOff > 0) {
                int working = 0;
                int encIndex = 0;
                int shift = 0;
                for (int i = 0; i < decOff; ++i) {
                    this._encodedBuffer[encIndex++] = STANDARD_ENCODABET[(working |= this._decodedBuffer[i] & 0xFF) >>> (shift += 2) & 0x3F];
                    if (shift == 6) {
                        this._encodedBuffer[encIndex++] = STANDARD_ENCODABET[working & 0x3F];
                        shift = 0;
                    }
                    working <<= 8;
                }
                if (shift != 0) {
                    this._encodedBuffer[encIndex++] = STANDARD_ENCODABET[working >>> shift + 2 & 0x3F];
                    shift += 2;
                    while (shift <= 6) {
                        this._encodedBuffer[encIndex++] = 61;
                        shift += 2;
                    }
                }
                out.write(this._encodedBuffer, 0, encIndex);
            }
            decOff = 0;
            decLen = this._decodedBuffer.length;
        } while (numBytes >= 0);
    }

    static {
        int i;
        STANDARD_ENCODABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        STANDARD_DECODABET = new byte[256];
        for (i = 0; i < STANDARD_DECODABET.length; ++i) {
            Base64.STANDARD_DECODABET[i] = -1;
        }
        for (i = 0; i < STANDARD_ENCODABET.length; ++i) {
            Base64.STANDARD_DECODABET[Base64.STANDARD_ENCODABET[i] & 0xFF] = (byte)i;
        }
    }
}

