/*
 * Decompiled with CFR 0.152.
 */
package com.github.memorylorry.type;

import com.github.memorylorry.config.ChartType;
import com.github.memorylorry.type.common.Column;
import com.github.memorylorry.type.common.CommonList;
import com.github.memorylorry.type.common.Filter;
import com.github.memorylorry.type.common.Order;
import com.github.memorylorry.type.common.Table;
import java.util.List;

public class Slice {
    private String title;
    private String database;
    private Table table;
    private String type;
    private CommonList<Column> dimensions;
    private CommonList<Column> metrics;
    private CommonList<Filter> filters;
    private CommonList<Order> orders;
    private String limit;

    public String toString() {
        int chartType = ChartType.getDimension(this.type);
        String sql = "SELECT ";
        if (chartType == 0) {
            sql = sql + this.metrics.toSQLWithAS();
        } else if (chartType == 1) {
            int dimensionSize = this.dimensions.getColumns().size();
            if (dimensionSize == 1) {
                CommonList<Column> columns = this.dimensions.addColumnList(this.metrics);
                sql = sql + columns.toSQLWithAS();
            } else {
                String concatSQL = this.dimensions.toSQLDivdByValue(",',',");
                if (concatSQL.length() > 0) {
                    concatSQL = "CONCAT(" + concatSQL + ") AS CONCAT_NAME";
                    sql = sql + concatSQL;
                }
                String metricSQL = "";
                if (this.metrics.getColumns().size() > 0) {
                    metricSQL = metricSQL + "," + this.metrics.toSQLWithAS();
                    if (concatSQL.length() > 0) {
                        sql = sql + metricSQL;
                    } else {
                        metricSQL = metricSQL.substring(1, metricSQL.length());
                        sql = sql + metricSQL;
                    }
                }
            }
        } else {
            CommonList<Column> columns = this.dimensions.addColumnList(this.metrics);
            sql = sql + columns.toSQLWithAS();
        }
        sql = sql + " FROM " + this.table.toSQL();
        CommonList<Filter> dimensionFilter = new CommonList<Filter>();
        CommonList<Filter> metricFilter = new CommonList<Filter>();
        List<Filter> res = this.filters.getColumns();
        for (Filter filter : res) {
            if (filter.getType() == 0) {
                dimensionFilter.addColumn(filter);
                continue;
            }
            metricFilter.addColumn(filter);
        }
        if (dimensionFilter.getColumns().size() > 0) {
            sql = sql + " WHERE " + dimensionFilter.toSQLDivdByValue(" AND ");
        }
        if (this.dimensions.getColumns().size() > 0) {
            sql = sql + " GROUP BY " + this.dimensions.toSQL();
        }
        if (metricFilter.getColumns().size() > 0) {
            sql = sql + " HAVING " + metricFilter.toSQLDivdByValue(" AND ");
        }
        if (this.orders.getColumns().size() > 0) {
            sql = sql + " ORDER BY " + this.orders.toSQL();
        }
        if (!"".equals(this.limit)) {
            sql = sql + " LIMIT " + this.limit;
        }
        return sql;
    }

    public String toCountSQL() {
        String sql = "SELECT count(1) FROM ";
        sql = sql + this.table.toSQL();
        CommonList<Filter> dimensionFilter = new CommonList<Filter>();
        CommonList<Filter> metricFilter = new CommonList<Filter>();
        List<Filter> res = this.filters.getColumns();
        for (Filter filter : res) {
            if (filter.getType() == 0) {
                dimensionFilter.addColumn(filter);
                continue;
            }
            metricFilter.addColumn(filter);
        }
        if (dimensionFilter.getColumns().size() > 0) {
            sql = sql + " WHERE " + dimensionFilter.toSQLDivdByValue(" AND ");
        }
        if (this.dimensions.getColumns().size() > 0) {
            sql = sql + " GROUP BY " + this.dimensions.toSQL();
            if (metricFilter.getColumns().size() > 0) {
                sql = sql + " HAVING " + metricFilter.toSQLDivdByValue(" AND ");
            }
        }
        sql = "SELECT COUNT(1) FROM (" + sql + ") tmp";
        return sql;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public CommonList<Column> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(CommonList<Column> dimensions) {
        this.dimensions = dimensions;
    }

    public CommonList<Column> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(CommonList<Column> metrics) {
        this.metrics = metrics;
    }

    public CommonList<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(CommonList<Filter> filters) {
        this.filters = filters;
    }

    public CommonList<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(CommonList<Order> orders) {
        this.orders = orders;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }
}

