/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import tss.Helpers;
import tss.TpmMarshaller;
import tss.TpmStructure;

public class OutByteBuf {
    ByteArrayOutputStream s = new ByteArrayOutputStream();

    public void reset() {
        this.s.reset();
    }

    public void write(byte x) {
        this.s.write(x);
    }

    public void write(short x) {
        try {
            this.s.write(Helpers.hostToNet(x));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public void write(int x) {
        try {
            this.s.write(Helpers.hostToNet(x));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public void write(long x) {
        try {
            this.s.write(Helpers.hostToNet(x));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public void write(byte[] x) {
        if (x == null) {
            return;
        }
        this.s.write(x, 0, x.length);
    }

    public void writeInt(int val, int numBytes) {
        switch (numBytes) {
            case 1: {
                this.write((byte)val);
                return;
            }
            case 2: {
                this.write((short)val);
                return;
            }
            case 4: {
                this.write(val);
                return;
            }
        }
        assert (false);
    }

    public void writeLong(long val) {
        this.write(val);
    }

    public void write(TpmMarshaller o) {
        o.toTpm(this);
    }

    public void writeArrayOfTpmObjects(Object arr) {
        Object[] objs;
        if (arr == null) {
            return;
        }
        for (Object o : objs = (Object[])arr) {
            TpmStructure xx = (TpmStructure)o;
            try {
                xx.toTpm(this);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static byte[] arrayToByteBuf(TpmStructure[] arr) {
        OutByteBuf buf = new OutByteBuf();
        TpmStructure[] tpmStructureArray = arr;
        int n = tpmStructureArray.length;
        for (int i = 0; i < n; ++i) {
            TpmStructure o;
            TpmStructure xx = o = tpmStructureArray[i];
            try {
                xx.toTpm(buf);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                throw new AssertionError((Object)"Marshalling error");
            }
        }
        return buf.getBuf();
    }

    public void writeArray(byte[] x) {
        if (x == null) {
            return;
        }
        this.write(x);
    }

    public void writeArray(short[] x) {
        if (x == null) {
            return;
        }
        for (int j = 0; j < x.length; ++j) {
            this.write(x[j]);
        }
    }

    public void writeArray(int[] x) {
        if (x == null) {
            return;
        }
        for (int j = 0; j < x.length; ++j) {
            this.write(x[j]);
        }
    }

    public void writeArrayFragment(byte[] x, int start, int end) {
        if (x == null) {
            return;
        }
        for (int j = start; j < end; ++j) {
            this.write(x[j]);
        }
    }

    public void writeArrayOfIntTypes(Object[] objs, int intSize) {
    }

    public byte[] getBuf() {
        return this.s.toByteArray();
    }

    public int size() {
        return this.s.size();
    }
}

