/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import tss.Helpers;
import tss.TpmDeviceBase;
import tss.TpmException;

public class TpmDeviceTcp
extends TpmDeviceBase {
    Socket CommandSocket;
    Socket SignalSocket;
    boolean responsePending;
    int currentLocality;

    public TpmDeviceTcp(String hostName, int port) {
        try {
            this.CommandSocket = new Socket(hostName, port);
            this.SignalSocket = new Socket(hostName, port + 1);
        }
        catch (UnknownHostException e) {
            throw new TpmException("Failed to connect to the TPM at " + hostName + ":" + Integer.toString(port) + "/" + Integer.toString(port + 1), e);
        }
        catch (IOException e) {
            throw new TpmException("Failed to connect to the TPM at " + hostName + ":" + Integer.toString(port) + "/" + Integer.toString(port + 1), e);
        }
    }

    @Override
    public void dispatchCommand(byte[] commandBuffer) {
        byte[] locality = new byte[]{(byte)this.currentLocality};
        this.writeInt(this.CommandSocket, TcpTpmCommands.SendCommand.Val);
        this.writeBuf(this.CommandSocket, locality);
        this.writeInt(this.CommandSocket, commandBuffer.length);
        try {
            this.CommandSocket.getOutputStream().write(commandBuffer);
            this.responsePending = true;
        }
        catch (IOException e) {
            throw new TpmException("Error sending data to the TPM", e);
        }
    }

    @Override
    public byte[] getResponse() {
        if (!this.responsePending) {
            throw new TpmException("Cannot getResponse() without a prior dispatchCommand()");
        }
        this.responsePending = false;
        byte[] outBuf = this.readEncapsulated(this.CommandSocket);
        this.readInt(this.CommandSocket);
        return outBuf;
    }

    @Override
    public boolean responseReady() {
        int available;
        if (!this.responsePending) {
            throw new TpmException("Cannot responseReady() without a prior dispatchCommand()");
        }
        try {
            available = this.CommandSocket.getInputStream().available();
        }
        catch (IOException e) {
            throw new TpmException("Error getting data from the TPM", e);
        }
        return available > 0;
    }

    @Override
    public void powerCycle() {
        this.powerOff();
        this.powerOn();
    }

    @Override
    public void powerOff() {
        this.sendCmdAndGetAck(this.SignalSocket, TcpTpmCommands.SignalPowerOff);
        this.sendCmdAndGetAck(this.SignalSocket, TcpTpmCommands.SignalNvOff);
    }

    @Override
    public void powerOn() {
        this.sendCmdAndGetAck(this.SignalSocket, TcpTpmCommands.SignalPowerOn);
        this.sendCmdAndGetAck(this.SignalSocket, TcpTpmCommands.SignalNvOn);
    }

    @Override
    public void setLocality(int locality) {
        this.currentLocality = locality;
    }

    public void sendCmdAndGetAck(Socket s, TcpTpmCommands comm) {
        this.writeEncapsulated(s, Helpers.hostToNet(comm.getVal()));
        this.getAck(s);
    }

    private void getAck(Socket s) {
        this.readInt(s);
    }

    private int readInt(Socket s) {
        int val = -1;
        try {
            val = Helpers.netToHost(this.readBuf(s, 4));
        }
        catch (Exception e) {
            throw new TpmException("TPM IO error", e);
        }
        return val;
    }

    private void writeInt(Socket s, int val) {
        this.writeBuf(s, Helpers.hostToNet(val));
    }

    private void writeBuf(Socket s, byte[] buffer) {
        try {
            s.getOutputStream().write(buffer, 0, buffer.length);
        }
        catch (IOException e) {
            throw new TpmException("TPM IO error", e);
        }
    }

    private byte[] readBuf(Socket s, int numBytes) {
        int sz;
        byte[] buf = new byte[numBytes];
        for (int numRead = 0; numRead < numBytes; numRead += sz) {
            try {
                sz = s.getInputStream().read(buf, numRead, numBytes - numRead);
                continue;
            }
            catch (IOException e) {
                throw new TpmException("TPM IO error", e);
            }
        }
        return buf;
    }

    private void writeEncapsulated(Socket s, byte[] buf) {
        this.writeBuf(s, Helpers.hostToNet(buf.length));
        this.writeBuf(s, buf);
    }

    private byte[] readEncapsulated(Socket s) {
        byte[] t = this.readBuf(s, 4);
        int sz = Helpers.netToHost(t);
        return this.readBuf(s, sz);
    }

    @Override
    public void close() throws IOException {
        this.CommandSocket.close();
        this.SignalSocket.close();
        this.CommandSocket = null;
        this.SignalSocket = null;
    }

    static enum TcpTpmCommands {
        SignalPowerOn(1),
        SignalPowerOff(2),
        SignalPPOn(3),
        SignalPPOff(4),
        SignalHashStart(5),
        SignalHashData(6),
        SignalHashEnd(7),
        SendCommand(8),
        SignalCancelOn(9),
        SignalCancelOff(10),
        SignalNvOn(11),
        SignalNvOff(12),
        SignalKeyCacheOn(13),
        SignalKeyCacheOff(14),
        RemoteHandshake(15),
        SessionEnd(20),
        Stop(21),
        TestFailureMode(30);

        private int Val;

        private TcpTpmCommands(int val) {
            this.setVal(val);
        }

        public int getVal() {
            return this.Val;
        }

        public void setVal(int val) {
            this.Val = val;
        }
    }
}

