/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_SENSITIVE;

public class TPM2B_SENSITIVE
extends TpmStructure {
    public TPMT_SENSITIVE sensitiveArea;

    public TPM2B_SENSITIVE(TPMT_SENSITIVE _sensitiveArea) {
        this.sensitiveArea = _sensitiveArea;
    }

    public TPM2B_SENSITIVE() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.sensitiveArea != null ? this.sensitiveArea.toTpm().length : 0, 2);
        this.sensitiveArea.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _size = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _size));
        this.sensitiveArea = TPMT_SENSITIVE.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2B_SENSITIVE fromTpm(byte[] x) {
        TPM2B_SENSITIVE ret = new TPM2B_SENSITIVE();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2B_SENSITIVE fromTpm(InByteBuf buf) {
        TPM2B_SENSITIVE ret = new TPM2B_SENSITIVE();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2B_SENSITIVE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_SENSITIVE", "sensitiveArea", this.sensitiveArea);
    }
}

