/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_AC_Send_REQUEST
extends TpmStructure {
    public TPM_HANDLE sendObject;
    public TPM_HANDLE authHandle;
    public TPM_HANDLE ac;
    public byte[] acDataIn;

    public TPM2_AC_Send_REQUEST(TPM_HANDLE _sendObject, TPM_HANDLE _authHandle, TPM_HANDLE _ac, byte[] _acDataIn) {
        this.sendObject = _sendObject;
        this.authHandle = _authHandle;
        this.ac = _ac;
        this.acDataIn = _acDataIn;
    }

    public TPM2_AC_Send_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.sendObject.toTpm(buf);
        this.authHandle.toTpm(buf);
        this.ac.toTpm(buf);
        buf.writeInt(this.acDataIn != null ? this.acDataIn.length : 0, 2);
        buf.write(this.acDataIn);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.sendObject = TPM_HANDLE.fromTpm(buf);
        this.authHandle = TPM_HANDLE.fromTpm(buf);
        this.ac = TPM_HANDLE.fromTpm(buf);
        int _acDataInSize = buf.readInt(2);
        this.acDataIn = new byte[_acDataInSize];
        buf.readArrayOfInts(this.acDataIn, 1, _acDataInSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_AC_Send_REQUEST fromTpm(byte[] x) {
        TPM2_AC_Send_REQUEST ret = new TPM2_AC_Send_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_AC_Send_REQUEST fromTpm(InByteBuf buf) {
        TPM2_AC_Send_REQUEST ret = new TPM2_AC_Send_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_AC_Send_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "sendObject", this.sendObject);
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "TPM_HANDLE", "ac", this.ac);
        _p.add(d, "byte", "acDataIn", this.acDataIn);
    }
}

