/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_SENSITIVE_CREATE;
import tss.tpm.TPM_HANDLE;

public class TPM2_CreateLoaded_REQUEST
extends TpmStructure {
    public TPM_HANDLE parentHandle;
    public TPMS_SENSITIVE_CREATE inSensitive;
    public byte[] inPublic;

    public TPM2_CreateLoaded_REQUEST(TPM_HANDLE _parentHandle, TPMS_SENSITIVE_CREATE _inSensitive, byte[] _inPublic) {
        this.parentHandle = _parentHandle;
        this.inSensitive = _inSensitive;
        this.inPublic = _inPublic;
    }

    public TPM2_CreateLoaded_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.parentHandle.toTpm(buf);
        buf.writeInt(this.inSensitive != null ? this.inSensitive.toTpm().length : 0, 2);
        this.inSensitive.toTpm(buf);
        buf.writeInt(this.inPublic != null ? this.inPublic.length : 0, 2);
        buf.write(this.inPublic);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.parentHandle = TPM_HANDLE.fromTpm(buf);
        int _inSensitiveSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _inSensitiveSize));
        this.inSensitive = TPMS_SENSITIVE_CREATE.fromTpm(buf);
        buf.structSize.pop();
        int _inPublicSize = buf.readInt(2);
        this.inPublic = new byte[_inPublicSize];
        buf.readArrayOfInts(this.inPublic, 1, _inPublicSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_CreateLoaded_REQUEST fromTpm(byte[] x) {
        TPM2_CreateLoaded_REQUEST ret = new TPM2_CreateLoaded_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_CreateLoaded_REQUEST fromTpm(InByteBuf buf) {
        TPM2_CreateLoaded_REQUEST ret = new TPM2_CreateLoaded_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_CreateLoaded_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "parentHandle", this.parentHandle);
        _p.add(d, "TPMS_SENSITIVE_CREATE", "inSensitive", this.inSensitive);
        _p.add(d, "byte", "inPublic", this.inPublic);
    }
}

