/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SIGNATURE;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SIGNATURE_ECDAA;
import tss.tpm.TPMS_SIGNATURE_ECDSA;
import tss.tpm.TPMS_SIGNATURE_ECSCHNORR;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMS_SIGNATURE_SM2;
import tss.tpm.TPMT_HA;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_FieldUpgradeStart_REQUEST
extends TpmStructure {
    public TPM_HANDLE authorization;
    public TPM_HANDLE keyHandle;
    public byte[] fuDigest;
    public TPMU_SIGNATURE manifestSignature;

    public TPM2_FieldUpgradeStart_REQUEST(TPM_HANDLE _authorization, TPM_HANDLE _keyHandle, byte[] _fuDigest, TPMU_SIGNATURE _manifestSignature) {
        this.authorization = _authorization;
        this.keyHandle = _keyHandle;
        this.fuDigest = _fuDigest;
        this.manifestSignature = _manifestSignature;
    }

    public TPM2_FieldUpgradeStart_REQUEST() {
    }

    public int GetUnionSelector_manifestSignature() {
        if (this.manifestSignature instanceof TPMS_SIGNATURE_RSASSA) {
            return 20;
        }
        if (this.manifestSignature instanceof TPMS_SIGNATURE_RSAPSS) {
            return 22;
        }
        if (this.manifestSignature instanceof TPMS_SIGNATURE_ECDSA) {
            return 24;
        }
        if (this.manifestSignature instanceof TPMS_SIGNATURE_ECDAA) {
            return 26;
        }
        if (this.manifestSignature instanceof TPMS_SIGNATURE_SM2) {
            return 27;
        }
        if (this.manifestSignature instanceof TPMS_SIGNATURE_ECSCHNORR) {
            return 28;
        }
        if (this.manifestSignature instanceof TPMT_HA) {
            return 5;
        }
        if (this.manifestSignature instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.manifestSignature instanceof TPMS_NULL_SIGNATURE) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authorization.toTpm(buf);
        this.keyHandle.toTpm(buf);
        buf.writeInt(this.fuDigest != null ? this.fuDigest.length : 0, 2);
        buf.write(this.fuDigest);
        buf.writeInt(this.GetUnionSelector_manifestSignature(), 2);
        this.manifestSignature.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authorization = TPM_HANDLE.fromTpm(buf);
        this.keyHandle = TPM_HANDLE.fromTpm(buf);
        int _fuDigestSize = buf.readInt(2);
        this.fuDigest = new byte[_fuDigestSize];
        buf.readArrayOfInts(this.fuDigest, 1, _fuDigestSize);
        int _manifestSignatureSigAlg = buf.readInt(2);
        this.manifestSignature = null;
        if (_manifestSignatureSigAlg == TPM_ALG_ID.RSASSA.toInt()) {
            this.manifestSignature = new TPMS_SIGNATURE_RSASSA();
        } else if (_manifestSignatureSigAlg == TPM_ALG_ID.RSAPSS.toInt()) {
            this.manifestSignature = new TPMS_SIGNATURE_RSAPSS();
        } else if (_manifestSignatureSigAlg == TPM_ALG_ID.ECDSA.toInt()) {
            this.manifestSignature = new TPMS_SIGNATURE_ECDSA();
        } else if (_manifestSignatureSigAlg == TPM_ALG_ID.ECDAA.toInt()) {
            this.manifestSignature = new TPMS_SIGNATURE_ECDAA();
        } else if (_manifestSignatureSigAlg == TPM_ALG_ID.ANY.toInt()) {
            this.manifestSignature = new TPMS_SCHEME_HASH();
        } else if (_manifestSignatureSigAlg == TPM_ALG_ID.NULL.toInt()) {
            this.manifestSignature = new TPMS_NULL_SIGNATURE();
        }
        if (this.manifestSignature == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.manifestSignature.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_FieldUpgradeStart_REQUEST fromTpm(byte[] x) {
        TPM2_FieldUpgradeStart_REQUEST ret = new TPM2_FieldUpgradeStart_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_FieldUpgradeStart_REQUEST fromTpm(InByteBuf buf) {
        TPM2_FieldUpgradeStart_REQUEST ret = new TPM2_FieldUpgradeStart_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_FieldUpgradeStart_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authorization", this.authorization);
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte", "fuDigest", this.fuDigest);
        _p.add(d, "TPMU_SIGNATURE", "manifestSignature", this.manifestSignature);
    }
}

