/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SIG_SCHEME;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SIG_SCHEME_ECDAA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_ECSCHNORR;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_SM2;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_GetCommandAuditDigest_REQUEST
extends TpmStructure {
    public TPM_HANDLE privacyHandle;
    public TPM_HANDLE signHandle;
    public byte[] qualifyingData;
    public TPMU_SIG_SCHEME inScheme;

    public TPM2_GetCommandAuditDigest_REQUEST(TPM_HANDLE _privacyHandle, TPM_HANDLE _signHandle, byte[] _qualifyingData, TPMU_SIG_SCHEME _inScheme) {
        this.privacyHandle = _privacyHandle;
        this.signHandle = _signHandle;
        this.qualifyingData = _qualifyingData;
        this.inScheme = _inScheme;
    }

    public TPM2_GetCommandAuditDigest_REQUEST() {
    }

    public int GetUnionSelector_inScheme() {
        if (this.inScheme instanceof TPMS_SIG_SCHEME_RSASSA) {
            return 20;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_RSAPSS) {
            return 22;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECDSA) {
            return 24;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECDAA) {
            return 26;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_SM2) {
            return 27;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECSCHNORR) {
            return 28;
        }
        if (this.inScheme instanceof TPMS_SCHEME_HMAC) {
            return 5;
        }
        if (this.inScheme instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.inScheme instanceof TPMS_NULL_SIG_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.privacyHandle.toTpm(buf);
        this.signHandle.toTpm(buf);
        buf.writeInt(this.qualifyingData != null ? this.qualifyingData.length : 0, 2);
        buf.write(this.qualifyingData);
        buf.writeInt(this.GetUnionSelector_inScheme(), 2);
        this.inScheme.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.privacyHandle = TPM_HANDLE.fromTpm(buf);
        this.signHandle = TPM_HANDLE.fromTpm(buf);
        int _qualifyingDataSize = buf.readInt(2);
        this.qualifyingData = new byte[_qualifyingDataSize];
        buf.readArrayOfInts(this.qualifyingData, 1, _qualifyingDataSize);
        int _inSchemeScheme = buf.readInt(2);
        this.inScheme = null;
        if (_inSchemeScheme == TPM_ALG_ID.RSASSA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_RSASSA();
        } else if (_inSchemeScheme == TPM_ALG_ID.RSAPSS.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_RSAPSS();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECDSA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_ECDSA();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECDAA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_ECDAA();
        } else if (_inSchemeScheme == TPM_ALG_ID.HMAC.toInt()) {
            this.inScheme = new TPMS_SCHEME_HMAC();
        } else if (_inSchemeScheme == TPM_ALG_ID.ANY.toInt()) {
            this.inScheme = new TPMS_SCHEME_HASH();
        } else if (_inSchemeScheme == TPM_ALG_ID.NULL.toInt()) {
            this.inScheme = new TPMS_NULL_SIG_SCHEME();
        }
        if (this.inScheme == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.inScheme.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_GetCommandAuditDigest_REQUEST fromTpm(byte[] x) {
        TPM2_GetCommandAuditDigest_REQUEST ret = new TPM2_GetCommandAuditDigest_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_GetCommandAuditDigest_REQUEST fromTpm(InByteBuf buf) {
        TPM2_GetCommandAuditDigest_REQUEST ret = new TPM2_GetCommandAuditDigest_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_GetCommandAuditDigest_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "privacyHandle", this.privacyHandle);
        _p.add(d, "TPM_HANDLE", "signHandle", this.signHandle);
        _p.add(d, "byte", "qualifyingData", this.qualifyingData);
        _p.add(d, "TPMU_SIG_SCHEME", "inScheme", this.inScheme);
    }
}

