/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPM_HANDLE;

public class TPM2_Import_REQUEST
extends TpmStructure {
    public TPM_HANDLE parentHandle;
    public byte[] encryptionKey;
    public TPMT_PUBLIC objectPublic;
    public TPM2B_PRIVATE duplicate;
    public byte[] inSymSeed;
    public TPMT_SYM_DEF_OBJECT symmetricAlg;

    public TPM2_Import_REQUEST(TPM_HANDLE _parentHandle, byte[] _encryptionKey, TPMT_PUBLIC _objectPublic, TPM2B_PRIVATE _duplicate, byte[] _inSymSeed, TPMT_SYM_DEF_OBJECT _symmetricAlg) {
        this.parentHandle = _parentHandle;
        this.encryptionKey = _encryptionKey;
        this.objectPublic = _objectPublic;
        this.duplicate = _duplicate;
        this.inSymSeed = _inSymSeed;
        this.symmetricAlg = _symmetricAlg;
    }

    public TPM2_Import_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.parentHandle.toTpm(buf);
        buf.writeInt(this.encryptionKey != null ? this.encryptionKey.length : 0, 2);
        buf.write(this.encryptionKey);
        buf.writeInt(this.objectPublic != null ? this.objectPublic.toTpm().length : 0, 2);
        this.objectPublic.toTpm(buf);
        this.duplicate.toTpm(buf);
        buf.writeInt(this.inSymSeed != null ? this.inSymSeed.length : 0, 2);
        buf.write(this.inSymSeed);
        this.symmetricAlg.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.parentHandle = TPM_HANDLE.fromTpm(buf);
        int _encryptionKeySize = buf.readInt(2);
        this.encryptionKey = new byte[_encryptionKeySize];
        buf.readArrayOfInts(this.encryptionKey, 1, _encryptionKeySize);
        int _objectPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _objectPublicSize));
        this.objectPublic = TPMT_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
        this.duplicate = TPM2B_PRIVATE.fromTpm(buf);
        int _inSymSeedSize = buf.readInt(2);
        this.inSymSeed = new byte[_inSymSeedSize];
        buf.readArrayOfInts(this.inSymSeed, 1, _inSymSeedSize);
        this.symmetricAlg = TPMT_SYM_DEF_OBJECT.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_Import_REQUEST fromTpm(byte[] x) {
        TPM2_Import_REQUEST ret = new TPM2_Import_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_Import_REQUEST fromTpm(InByteBuf buf) {
        TPM2_Import_REQUEST ret = new TPM2_Import_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Import_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "parentHandle", this.parentHandle);
        _p.add(d, "byte", "encryptionKey", this.encryptionKey);
        _p.add(d, "TPMT_PUBLIC", "objectPublic", this.objectPublic);
        _p.add(d, "TPM2B_PRIVATE", "duplicate", this.duplicate);
        _p.add(d, "byte", "inSymSeed", this.inSymSeed);
        _p.add(d, "TPMT_SYM_DEF_OBJECT", "symmetricAlg", this.symmetricAlg);
    }
}

