/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_NV_ChangeAuth_REQUEST
extends TpmStructure {
    public TPM_HANDLE nvIndex;
    public byte[] newAuth;

    public TPM2_NV_ChangeAuth_REQUEST(TPM_HANDLE _nvIndex, byte[] _newAuth) {
        this.nvIndex = _nvIndex;
        this.newAuth = _newAuth;
    }

    public TPM2_NV_ChangeAuth_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.nvIndex.toTpm(buf);
        buf.writeInt(this.newAuth != null ? this.newAuth.length : 0, 2);
        buf.write(this.newAuth);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.nvIndex = TPM_HANDLE.fromTpm(buf);
        int _newAuthSize = buf.readInt(2);
        this.newAuth = new byte[_newAuthSize];
        buf.readArrayOfInts(this.newAuth, 1, _newAuthSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_NV_ChangeAuth_REQUEST fromTpm(byte[] x) {
        TPM2_NV_ChangeAuth_REQUEST ret = new TPM2_NV_ChangeAuth_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_NV_ChangeAuth_REQUEST fromTpm(InByteBuf buf) {
        TPM2_NV_ChangeAuth_REQUEST ret = new TPM2_NV_ChangeAuth_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_NV_ChangeAuth_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "nvIndex", this.nvIndex);
        _p.add(d, "byte", "newAuth", this.newAuth);
    }
}

