/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_DIGEST;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyOR_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public TPM2B_DIGEST[] pHashList;

    public TPM2_PolicyOR_REQUEST(TPM_HANDLE _policySession, TPM2B_DIGEST[] _pHashList) {
        this.policySession = _policySession;
        this.pHashList = _pHashList;
    }

    public TPM2_PolicyOR_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.pHashList != null ? this.pHashList.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.pHashList);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _pHashListCount = buf.readInt(4);
        this.pHashList = new TPM2B_DIGEST[_pHashListCount];
        for (int j = 0; j < _pHashListCount; ++j) {
            this.pHashList[j] = new TPM2B_DIGEST();
        }
        buf.readArrayOfTpmObjects(this.pHashList, _pHashListCount);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicyOR_REQUEST fromTpm(byte[] x) {
        TPM2_PolicyOR_REQUEST ret = new TPM2_PolicyOR_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicyOR_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicyOR_REQUEST ret = new TPM2_PolicyOR_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyOR_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "TPM2B_DIGEST", "pHashList", this.pHashList);
    }
}

