/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_SetAlgorithmSet_REQUEST
extends TpmStructure {
    public TPM_HANDLE authHandle;
    public int algorithmSet;

    public TPM2_SetAlgorithmSet_REQUEST(TPM_HANDLE _authHandle, int _algorithmSet) {
        this.authHandle = _authHandle;
        this.algorithmSet = _algorithmSet;
    }

    public TPM2_SetAlgorithmSet_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authHandle.toTpm(buf);
        buf.write(this.algorithmSet);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authHandle = TPM_HANDLE.fromTpm(buf);
        this.algorithmSet = buf.readInt(4);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_SetAlgorithmSet_REQUEST fromTpm(byte[] x) {
        TPM2_SetAlgorithmSet_REQUEST ret = new TPM2_SetAlgorithmSet_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_SetAlgorithmSet_REQUEST fromTpm(InByteBuf buf) {
        TPM2_SetAlgorithmSet_REQUEST ret = new TPM2_SetAlgorithmSet_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_SetAlgorithmSet_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "uint", "algorithmSet", this.algorithmSet);
    }
}

