/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;

public class TPML_ALG
extends TpmStructure {
    public TPM_ALG_ID[] algorithms;

    public TPML_ALG(TPM_ALG_ID[] _algorithms) {
        this.algorithms = _algorithms;
    }

    public TPML_ALG() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.algorithms != null ? this.algorithms.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.algorithms);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _count = buf.readInt(4);
        this.algorithms = new TPM_ALG_ID[_count];
        for (int j = 0; j < _count; ++j) {
            this.algorithms[j] = TPM_ALG_ID.fromTpm(buf);
        }
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPML_ALG fromTpm(byte[] x) {
        TPML_ALG ret = new TPML_ALG();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPML_ALG fromTpm(InByteBuf buf) {
        TPML_ALG ret = new TPML_ALG();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPML_ALG");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "algorithms", this.algorithms);
    }
}

