/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_SESSION;
import tss.tpm.TPM_HANDLE;

public class TPMS_AUTH_COMMAND
extends TpmStructure {
    public TPM_HANDLE sessionHandle;
    public byte[] nonce;
    public TPMA_SESSION sessionAttributes;
    public byte[] hmac;

    public TPMS_AUTH_COMMAND(TPM_HANDLE _sessionHandle, byte[] _nonce, TPMA_SESSION _sessionAttributes, byte[] _hmac) {
        this.sessionHandle = _sessionHandle;
        this.nonce = _nonce;
        this.sessionAttributes = _sessionAttributes;
        this.hmac = _hmac;
    }

    public TPMS_AUTH_COMMAND() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.sessionHandle.toTpm(buf);
        buf.writeInt(this.nonce != null ? this.nonce.length : 0, 2);
        buf.write(this.nonce);
        this.sessionAttributes.toTpm(buf);
        buf.writeInt(this.hmac != null ? this.hmac.length : 0, 2);
        buf.write(this.hmac);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.sessionHandle = TPM_HANDLE.fromTpm(buf);
        int _nonceSize = buf.readInt(2);
        this.nonce = new byte[_nonceSize];
        buf.readArrayOfInts(this.nonce, 1, _nonceSize);
        int _sessionAttributes = buf.readInt(1);
        this.sessionAttributes = TPMA_SESSION.fromInt(_sessionAttributes);
        int _hmacSize = buf.readInt(2);
        this.hmac = new byte[_hmacSize];
        buf.readArrayOfInts(this.hmac, 1, _hmacSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_AUTH_COMMAND fromTpm(byte[] x) {
        TPMS_AUTH_COMMAND ret = new TPMS_AUTH_COMMAND();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_AUTH_COMMAND fromTpm(InByteBuf buf) {
        TPMS_AUTH_COMMAND ret = new TPMS_AUTH_COMMAND();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_AUTH_COMMAND");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "sessionHandle", this.sessionHandle);
        _p.add(d, "byte", "nonce", this.nonce);
        _p.add(d, "TPMA_SESSION", "sessionAttributes", this.sessionAttributes);
        _p.add(d, "byte", "hmac", this.hmac);
    }
}

