/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SCHEME_KEYEDHASH;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SCHEME_XOR;
import tss.tpm.TPMU_PUBLIC_PARMS;
import tss.tpm.TPMU_SCHEME_KEYEDHASH;
import tss.tpm.TPM_ALG_ID;

public class TPMS_KEYEDHASH_PARMS
extends TpmStructure
implements TPMU_PUBLIC_PARMS {
    public TPMU_SCHEME_KEYEDHASH scheme;

    public TPMS_KEYEDHASH_PARMS(TPMU_SCHEME_KEYEDHASH _scheme) {
        this.scheme = _scheme;
    }

    public TPMS_KEYEDHASH_PARMS() {
    }

    public int GetUnionSelector_scheme() {
        if (this.scheme instanceof TPMS_SCHEME_HMAC) {
            return 5;
        }
        if (this.scheme instanceof TPMS_SCHEME_XOR) {
            return 10;
        }
        if (this.scheme instanceof TPMS_NULL_SCHEME_KEYEDHASH) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_scheme(), 2);
        this.scheme.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _schemeScheme = buf.readInt(2);
        this.scheme = null;
        if (_schemeScheme == TPM_ALG_ID.HMAC.toInt()) {
            this.scheme = new TPMS_SCHEME_HMAC();
        } else if (_schemeScheme == TPM_ALG_ID.XOR.toInt()) {
            this.scheme = new TPMS_SCHEME_XOR();
        } else if (_schemeScheme == TPM_ALG_ID.NULL.toInt()) {
            this.scheme = new TPMS_NULL_SCHEME_KEYEDHASH();
        }
        if (this.scheme == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.scheme.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_KEYEDHASH_PARMS fromTpm(byte[] x) {
        TPMS_KEYEDHASH_PARMS ret = new TPMS_KEYEDHASH_PARMS();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_KEYEDHASH_PARMS fromTpm(InByteBuf buf) {
        TPMS_KEYEDHASH_PARMS ret = new TPMS_KEYEDHASH_PARMS();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_KEYEDHASH_PARMS");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMU_SCHEME_KEYEDHASH", "scheme", this.scheme);
    }
}

