/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMU_ATTEST;

public class TPMS_QUOTE_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public TPMS_PCR_SELECTION[] pcrSelect;
    public byte[] pcrDigest;

    public TPMS_QUOTE_INFO(TPMS_PCR_SELECTION[] _pcrSelect, byte[] _pcrDigest) {
        this.pcrSelect = _pcrSelect;
        this.pcrDigest = _pcrDigest;
    }

    public TPMS_QUOTE_INFO() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.pcrSelect != null ? this.pcrSelect.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.pcrSelect);
        buf.writeInt(this.pcrDigest != null ? this.pcrDigest.length : 0, 2);
        buf.write(this.pcrDigest);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _pcrSelectCount = buf.readInt(4);
        this.pcrSelect = new TPMS_PCR_SELECTION[_pcrSelectCount];
        for (int j = 0; j < _pcrSelectCount; ++j) {
            this.pcrSelect[j] = new TPMS_PCR_SELECTION();
        }
        buf.readArrayOfTpmObjects(this.pcrSelect, _pcrSelectCount);
        int _pcrDigestSize = buf.readInt(2);
        this.pcrDigest = new byte[_pcrDigestSize];
        buf.readArrayOfInts(this.pcrDigest, 1, _pcrDigestSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_QUOTE_INFO fromTpm(byte[] x) {
        TPMS_QUOTE_INFO ret = new TPMS_QUOTE_INFO();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_QUOTE_INFO fromTpm(InByteBuf buf) {
        TPMS_QUOTE_INFO ret = new TPMS_QUOTE_INFO();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_QUOTE_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_PCR_SELECTION", "pcrSelect", this.pcrSelect);
        _p.add(d, "byte", "pcrDigest", this.pcrDigest);
    }
}

