/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_ATTEST;

public class TPMS_SESSION_AUDIT_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public byte exclusiveSession;
    public byte[] sessionDigest;

    public TPMS_SESSION_AUDIT_INFO(byte _exclusiveSession, byte[] _sessionDigest) {
        this.exclusiveSession = _exclusiveSession;
        this.sessionDigest = _sessionDigest;
    }

    public TPMS_SESSION_AUDIT_INFO() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.exclusiveSession);
        buf.writeInt(this.sessionDigest != null ? this.sessionDigest.length : 0, 2);
        buf.write(this.sessionDigest);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.exclusiveSession = (byte)buf.readInt(1);
        int _sessionDigestSize = buf.readInt(2);
        this.sessionDigest = new byte[_sessionDigestSize];
        buf.readArrayOfInts(this.sessionDigest, 1, _sessionDigestSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_SESSION_AUDIT_INFO fromTpm(byte[] x) {
        TPMS_SESSION_AUDIT_INFO ret = new TPMS_SESSION_AUDIT_INFO();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_SESSION_AUDIT_INFO fromTpm(InByteBuf buf) {
        TPMS_SESSION_AUDIT_INFO ret = new TPMS_SESSION_AUDIT_INFO();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_SESSION_AUDIT_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "BYTE", "exclusiveSession", this.exclusiveSession);
        _p.add(d, "byte", "sessionDigest", this.sessionDigest);
    }
}

