/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_ST;

public class TPMT_TK_HASHCHECK
extends TpmStructure {
    public TPM_ST tag;
    public TPM_HANDLE hierarchy;
    public byte[] digest;

    public TPMT_TK_HASHCHECK(TPM_ST _tag, TPM_HANDLE _hierarchy, byte[] _digest) {
        this.tag = _tag;
        this.hierarchy = _hierarchy;
        this.digest = _digest;
    }

    public TPMT_TK_HASHCHECK() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.tag.toTpm(buf);
        this.hierarchy.toTpm(buf);
        buf.writeInt(this.digest != null ? this.digest.length : 0, 2);
        buf.write(this.digest);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.tag = TPM_ST.fromTpm(buf);
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
        int _digestSize = buf.readInt(2);
        this.digest = new byte[_digestSize];
        buf.readArrayOfInts(this.digest, 1, _digestSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMT_TK_HASHCHECK fromTpm(byte[] x) {
        TPMT_TK_HASHCHECK ret = new TPMT_TK_HASHCHECK();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMT_TK_HASHCHECK fromTpm(InByteBuf buf) {
        TPMT_TK_HASHCHECK ret = new TPMT_TK_HASHCHECK();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_TK_HASHCHECK");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ST", "tag", this.tag);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
        _p.add(d, "byte", "digest", this.digest);
    }

    public static TPMT_TK_HASHCHECK nullTicket() {
        TPMT_TK_HASHCHECK t = new TPMT_TK_HASHCHECK();
        t.tag = TPM_ST.HASHCHECK;
        t.hierarchy = TPM_HANDLE.from(TPM_RH.OWNER);
        return t;
    }
}

