/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_DIGEST;
import tss.tpm.TPMS_PCR_SELECTION;

public class PCR_ReadResponse
extends TpmStructure {
    public int pcrUpdateCounter;
    public TPMS_PCR_SELECTION[] pcrSelectionOut;
    public TPM2B_DIGEST[] pcrValues;

    public PCR_ReadResponse(int _pcrUpdateCounter, TPMS_PCR_SELECTION[] _pcrSelectionOut, TPM2B_DIGEST[] _pcrValues) {
        this.pcrUpdateCounter = _pcrUpdateCounter;
        this.pcrSelectionOut = _pcrSelectionOut;
        this.pcrValues = _pcrValues;
    }

    public PCR_ReadResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.pcrUpdateCounter);
        buf.writeInt(this.pcrSelectionOut != null ? this.pcrSelectionOut.length : 0, 4);
        if (this.pcrSelectionOut != null) {
            buf.writeArrayOfTpmObjects(this.pcrSelectionOut);
        }
        buf.writeInt(this.pcrValues != null ? this.pcrValues.length : 0, 4);
        if (this.pcrValues != null) {
            buf.writeArrayOfTpmObjects(this.pcrValues);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.pcrUpdateCounter = buf.readInt(4);
        int _pcrSelectionOutCount = buf.readInt(4);
        this.pcrSelectionOut = new TPMS_PCR_SELECTION[_pcrSelectionOutCount];
        for (int j = 0; j < _pcrSelectionOutCount; ++j) {
            this.pcrSelectionOut[j] = new TPMS_PCR_SELECTION();
        }
        buf.readArrayOfTpmObjects(this.pcrSelectionOut, _pcrSelectionOutCount);
        int _pcrValuesCount = buf.readInt(4);
        this.pcrValues = new TPM2B_DIGEST[_pcrValuesCount];
        for (int j = 0; j < _pcrValuesCount; ++j) {
            this.pcrValues[j] = new TPM2B_DIGEST();
        }
        buf.readArrayOfTpmObjects(this.pcrValues, _pcrValuesCount);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static PCR_ReadResponse fromTpm(byte[] x) {
        PCR_ReadResponse ret = new PCR_ReadResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static PCR_ReadResponse fromTpm(InByteBuf buf) {
        PCR_ReadResponse ret = new PCR_ReadResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PCR_Read_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "uint", "pcrUpdateCounter", this.pcrUpdateCounter);
        _p.add(d, "TPMS_PCR_SELECTION", "pcrSelectionOut", this.pcrSelectionOut);
        _p.add(d, "TPM2B_DIGEST", "pcrValues", this.pcrValues);
    }
}

