/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;

public class RewrapResponse
extends TpmStructure {
    public TPM2B_PRIVATE outDuplicate;
    public byte[] outSymSeed;

    public RewrapResponse(TPM2B_PRIVATE _outDuplicate, byte[] _outSymSeed) {
        this.outDuplicate = _outDuplicate;
        this.outSymSeed = _outSymSeed;
    }

    public RewrapResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.outDuplicate.toTpm(buf);
        buf.writeInt(this.outSymSeed != null ? this.outSymSeed.length : 0, 2);
        if (this.outSymSeed != null) {
            buf.write(this.outSymSeed);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.outDuplicate = TPM2B_PRIVATE.fromTpm(buf);
        int _outSymSeedSize = buf.readInt(2);
        this.outSymSeed = new byte[_outSymSeedSize];
        buf.readArrayOfInts(this.outSymSeed, 1, _outSymSeedSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static RewrapResponse fromTpm(byte[] x) {
        RewrapResponse ret = new RewrapResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static RewrapResponse fromTpm(InByteBuf buf) {
        RewrapResponse ret = new RewrapResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Rewrap_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM2B_PRIVATE", "outDuplicate", this.outDuplicate);
        _p.add(d, "byte", "outSymSeed", this.outSymSeed);
    }
}

