/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SIG_SCHEME;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SIG_SCHEME_ECDAA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_ECSCHNORR;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_SM2;
import tss.tpm.TPMT_TK_CREATION;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_CertifyCreation_REQUEST
extends TpmStructure {
    public TPM_HANDLE signHandle;
    public TPM_HANDLE objectHandle;
    public byte[] qualifyingData;
    public byte[] creationHash;
    public TPMU_SIG_SCHEME inScheme;
    public TPMT_TK_CREATION creationTicket;

    public TPM2_CertifyCreation_REQUEST(TPM_HANDLE _signHandle, TPM_HANDLE _objectHandle, byte[] _qualifyingData, byte[] _creationHash, TPMU_SIG_SCHEME _inScheme, TPMT_TK_CREATION _creationTicket) {
        this.signHandle = _signHandle;
        this.objectHandle = _objectHandle;
        this.qualifyingData = _qualifyingData;
        this.creationHash = _creationHash;
        this.inScheme = _inScheme;
        this.creationTicket = _creationTicket;
    }

    public TPM2_CertifyCreation_REQUEST() {
    }

    public int GetUnionSelector_inScheme() {
        if (this.inScheme instanceof TPMS_SIG_SCHEME_RSASSA) {
            return 20;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_RSAPSS) {
            return 22;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECDSA) {
            return 24;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECDAA) {
            return 26;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_SM2) {
            return 27;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECSCHNORR) {
            return 28;
        }
        if (this.inScheme instanceof TPMS_SCHEME_HMAC) {
            return 5;
        }
        if (this.inScheme instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.inScheme instanceof TPMS_NULL_SIG_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.signHandle.toTpm(buf);
        this.objectHandle.toTpm(buf);
        buf.writeInt(this.qualifyingData != null ? this.qualifyingData.length : 0, 2);
        if (this.qualifyingData != null) {
            buf.write(this.qualifyingData);
        }
        buf.writeInt(this.creationHash != null ? this.creationHash.length : 0, 2);
        if (this.creationHash != null) {
            buf.write(this.creationHash);
        }
        buf.writeInt(this.GetUnionSelector_inScheme(), 2);
        this.inScheme.toTpm(buf);
        this.creationTicket.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.signHandle = TPM_HANDLE.fromTpm(buf);
        this.objectHandle = TPM_HANDLE.fromTpm(buf);
        int _qualifyingDataSize = buf.readInt(2);
        this.qualifyingData = new byte[_qualifyingDataSize];
        buf.readArrayOfInts(this.qualifyingData, 1, _qualifyingDataSize);
        int _creationHashSize = buf.readInt(2);
        this.creationHash = new byte[_creationHashSize];
        buf.readArrayOfInts(this.creationHash, 1, _creationHashSize);
        int _inSchemeScheme = buf.readInt(2);
        this.inScheme = null;
        if (_inSchemeScheme == TPM_ALG_ID.RSASSA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_RSASSA();
        } else if (_inSchemeScheme == TPM_ALG_ID.RSAPSS.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_RSAPSS();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECDSA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_ECDSA();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECDAA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_ECDAA();
        } else if (_inSchemeScheme == TPM_ALG_ID.HMAC.toInt()) {
            this.inScheme = new TPMS_SCHEME_HMAC();
        } else if (_inSchemeScheme == TPM_ALG_ID.ANY.toInt()) {
            this.inScheme = new TPMS_SCHEME_HASH();
        } else if (_inSchemeScheme == TPM_ALG_ID.NULL.toInt()) {
            this.inScheme = new TPMS_NULL_SIG_SCHEME();
        }
        if (this.inScheme == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_inSchemeScheme).name());
        }
        this.inScheme.initFromTpm(buf);
        this.creationTicket = TPMT_TK_CREATION.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_CertifyCreation_REQUEST fromTpm(byte[] x) {
        TPM2_CertifyCreation_REQUEST ret = new TPM2_CertifyCreation_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_CertifyCreation_REQUEST fromTpm(InByteBuf buf) {
        TPM2_CertifyCreation_REQUEST ret = new TPM2_CertifyCreation_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_CertifyCreation_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "signHandle", this.signHandle);
        _p.add(d, "TPM_HANDLE", "objectHandle", this.objectHandle);
        _p.add(d, "byte", "qualifyingData", this.qualifyingData);
        _p.add(d, "byte", "creationHash", this.creationHash);
        _p.add(d, "TPMU_SIG_SCHEME", "inScheme", this.inScheme);
        _p.add(d, "TPMT_TK_CREATION", "creationTicket", this.creationTicket);
    }
}

