/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPM_HANDLE;

public class TPM2_PCR_Allocate_REQUEST
extends TpmStructure {
    public TPM_HANDLE authHandle;
    public TPMS_PCR_SELECTION[] pcrAllocation;

    public TPM2_PCR_Allocate_REQUEST(TPM_HANDLE _authHandle, TPMS_PCR_SELECTION[] _pcrAllocation) {
        this.authHandle = _authHandle;
        this.pcrAllocation = _pcrAllocation;
    }

    public TPM2_PCR_Allocate_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authHandle.toTpm(buf);
        buf.writeInt(this.pcrAllocation != null ? this.pcrAllocation.length : 0, 4);
        if (this.pcrAllocation != null) {
            buf.writeArrayOfTpmObjects(this.pcrAllocation);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authHandle = TPM_HANDLE.fromTpm(buf);
        int _pcrAllocationCount = buf.readInt(4);
        this.pcrAllocation = new TPMS_PCR_SELECTION[_pcrAllocationCount];
        for (int j = 0; j < _pcrAllocationCount; ++j) {
            this.pcrAllocation[j] = new TPMS_PCR_SELECTION();
        }
        buf.readArrayOfTpmObjects(this.pcrAllocation, _pcrAllocationCount);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PCR_Allocate_REQUEST fromTpm(byte[] x) {
        TPM2_PCR_Allocate_REQUEST ret = new TPM2_PCR_Allocate_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PCR_Allocate_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PCR_Allocate_REQUEST ret = new TPM2_PCR_Allocate_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PCR_Allocate_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "TPMS_PCR_SELECTION", "pcrAllocation", this.pcrAllocation);
    }
}

