/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_TK_VERIFIED;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyAuthorize_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public byte[] approvedPolicy;
    public byte[] policyRef;
    public byte[] keySign;
    public TPMT_TK_VERIFIED checkTicket;

    public TPM2_PolicyAuthorize_REQUEST(TPM_HANDLE _policySession, byte[] _approvedPolicy, byte[] _policyRef, byte[] _keySign, TPMT_TK_VERIFIED _checkTicket) {
        this.policySession = _policySession;
        this.approvedPolicy = _approvedPolicy;
        this.policyRef = _policyRef;
        this.keySign = _keySign;
        this.checkTicket = _checkTicket;
    }

    public TPM2_PolicyAuthorize_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.approvedPolicy != null ? this.approvedPolicy.length : 0, 2);
        if (this.approvedPolicy != null) {
            buf.write(this.approvedPolicy);
        }
        buf.writeInt(this.policyRef != null ? this.policyRef.length : 0, 2);
        if (this.policyRef != null) {
            buf.write(this.policyRef);
        }
        buf.writeInt(this.keySign != null ? this.keySign.length : 0, 2);
        if (this.keySign != null) {
            buf.write(this.keySign);
        }
        this.checkTicket.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _approvedPolicySize = buf.readInt(2);
        this.approvedPolicy = new byte[_approvedPolicySize];
        buf.readArrayOfInts(this.approvedPolicy, 1, _approvedPolicySize);
        int _policyRefSize = buf.readInt(2);
        this.policyRef = new byte[_policyRefSize];
        buf.readArrayOfInts(this.policyRef, 1, _policyRefSize);
        int _keySignSize = buf.readInt(2);
        this.keySign = new byte[_keySignSize];
        buf.readArrayOfInts(this.keySign, 1, _keySignSize);
        this.checkTicket = TPMT_TK_VERIFIED.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicyAuthorize_REQUEST fromTpm(byte[] x) {
        TPM2_PolicyAuthorize_REQUEST ret = new TPM2_PolicyAuthorize_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicyAuthorize_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicyAuthorize_REQUEST ret = new TPM2_PolicyAuthorize_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyAuthorize_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "approvedPolicy", this.approvedPolicy);
        _p.add(d, "byte", "policyRef", this.policyRef);
        _p.add(d, "byte", "keySign", this.keySign);
        _p.add(d, "TPMT_TK_VERIFIED", "checkTicket", this.checkTicket);
    }
}

