/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_Policy_AC_SendSelect_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public byte[] objectName;
    public byte[] authHandleName;
    public byte[] acName;
    public byte includeObject;

    public TPM2_Policy_AC_SendSelect_REQUEST(TPM_HANDLE _policySession, byte[] _objectName, byte[] _authHandleName, byte[] _acName, byte _includeObject) {
        this.policySession = _policySession;
        this.objectName = _objectName;
        this.authHandleName = _authHandleName;
        this.acName = _acName;
        this.includeObject = _includeObject;
    }

    public TPM2_Policy_AC_SendSelect_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.objectName != null ? this.objectName.length : 0, 2);
        if (this.objectName != null) {
            buf.write(this.objectName);
        }
        buf.writeInt(this.authHandleName != null ? this.authHandleName.length : 0, 2);
        if (this.authHandleName != null) {
            buf.write(this.authHandleName);
        }
        buf.writeInt(this.acName != null ? this.acName.length : 0, 2);
        if (this.acName != null) {
            buf.write(this.acName);
        }
        buf.write(this.includeObject);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _objectNameSize = buf.readInt(2);
        this.objectName = new byte[_objectNameSize];
        buf.readArrayOfInts(this.objectName, 1, _objectNameSize);
        int _authHandleNameSize = buf.readInt(2);
        this.authHandleName = new byte[_authHandleNameSize];
        buf.readArrayOfInts(this.authHandleName, 1, _authHandleNameSize);
        int _acNameSize = buf.readInt(2);
        this.acName = new byte[_acNameSize];
        buf.readArrayOfInts(this.acName, 1, _acNameSize);
        this.includeObject = (byte)buf.readInt(1);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_Policy_AC_SendSelect_REQUEST fromTpm(byte[] x) {
        TPM2_Policy_AC_SendSelect_REQUEST ret = new TPM2_Policy_AC_SendSelect_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_Policy_AC_SendSelect_REQUEST fromTpm(InByteBuf buf) {
        TPM2_Policy_AC_SendSelect_REQUEST ret = new TPM2_Policy_AC_SendSelect_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Policy_AC_SendSelect_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "objectName", this.objectName);
        _p.add(d, "byte", "authHandleName", this.authHandleName);
        _p.add(d, "byte", "acName", this.acName);
        _p.add(d, "BYTE", "includeObject", this.includeObject);
    }
}

