/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SIG_SCHEME;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SIG_SCHEME_ECDAA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_ECSCHNORR;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_SM2;
import tss.tpm.TPMT_TK_HASHCHECK;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_Sign_REQUEST
extends TpmStructure {
    public TPM_HANDLE keyHandle;
    public byte[] digest;
    public TPMU_SIG_SCHEME inScheme;
    public TPMT_TK_HASHCHECK validation;

    public TPM2_Sign_REQUEST(TPM_HANDLE _keyHandle, byte[] _digest, TPMU_SIG_SCHEME _inScheme, TPMT_TK_HASHCHECK _validation) {
        this.keyHandle = _keyHandle;
        this.digest = _digest;
        this.inScheme = _inScheme;
        this.validation = _validation;
    }

    public TPM2_Sign_REQUEST() {
    }

    public int GetUnionSelector_inScheme() {
        if (this.inScheme instanceof TPMS_SIG_SCHEME_RSASSA) {
            return 20;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_RSAPSS) {
            return 22;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECDSA) {
            return 24;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECDAA) {
            return 26;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_SM2) {
            return 27;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECSCHNORR) {
            return 28;
        }
        if (this.inScheme instanceof TPMS_SCHEME_HMAC) {
            return 5;
        }
        if (this.inScheme instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.inScheme instanceof TPMS_NULL_SIG_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.keyHandle.toTpm(buf);
        buf.writeInt(this.digest != null ? this.digest.length : 0, 2);
        if (this.digest != null) {
            buf.write(this.digest);
        }
        buf.writeInt(this.GetUnionSelector_inScheme(), 2);
        this.inScheme.toTpm(buf);
        this.validation.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.keyHandle = TPM_HANDLE.fromTpm(buf);
        int _digestSize = buf.readInt(2);
        this.digest = new byte[_digestSize];
        buf.readArrayOfInts(this.digest, 1, _digestSize);
        int _inSchemeScheme = buf.readInt(2);
        this.inScheme = null;
        if (_inSchemeScheme == TPM_ALG_ID.RSASSA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_RSASSA();
        } else if (_inSchemeScheme == TPM_ALG_ID.RSAPSS.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_RSAPSS();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECDSA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_ECDSA();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECDAA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_ECDAA();
        } else if (_inSchemeScheme == TPM_ALG_ID.HMAC.toInt()) {
            this.inScheme = new TPMS_SCHEME_HMAC();
        } else if (_inSchemeScheme == TPM_ALG_ID.ANY.toInt()) {
            this.inScheme = new TPMS_SCHEME_HASH();
        } else if (_inSchemeScheme == TPM_ALG_ID.NULL.toInt()) {
            this.inScheme = new TPMS_NULL_SIG_SCHEME();
        }
        if (this.inScheme == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_inSchemeScheme).name());
        }
        this.inScheme.initFromTpm(buf);
        this.validation = TPMT_TK_HASHCHECK.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_Sign_REQUEST fromTpm(byte[] x) {
        TPM2_Sign_REQUEST ret = new TPM2_Sign_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_Sign_REQUEST fromTpm(InByteBuf buf) {
        TPM2_Sign_REQUEST ret = new TPM2_Sign_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Sign_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte", "digest", this.digest);
        _p.add(d, "TPMU_SIG_SCHEME", "inScheme", this.inScheme);
        _p.add(d, "TPMT_TK_HASHCHECK", "validation", this.validation);
    }
}

