/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi;

import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.EnvData;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.CmdPayload;
import com.github.mob41.blapi.pkt.Payload;
import java.io.IOException;
import java.net.DatagramPacket;
import javax.xml.bind.DatatypeConverter;

public class A1Device
extends BLDevice {
    public A1Device(String host, Mac mac) throws IOException {
        super((short)10004, "Environmental Sensor", host, mac);
    }

    public EnvData getSensorsData() throws Exception {
        DatagramPacket packet = this.sendCmdPkt(new CmdPayload(){

            @Override
            public byte getCommand() {
                return 106;
            }

            @Override
            public Payload getPayload() {
                return new Payload(){

                    @Override
                    public byte[] getData() {
                        byte[] b = new byte[16];
                        b[0] = 1;
                        return b;
                    }
                };
            }
        });
        byte[] data = packet.getData();
        log.debug("A1 check sensors received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        int err = data[34] | data[35] << 8;
        if (err == 0) {
            byte[] pl = this.decryptFromDeviceMessage(data);
            log.debug("A1 check sensors received bytes (decrypted):" + DatatypeConverter.printHexBinary((byte[])pl));
            float temp = (float)((double)(pl[4] * 10 + pl[5]) / 10.0);
            float hum = (float)((double)(pl[6] * 10 + pl[7]) / 10.0);
            byte light = pl[8];
            byte airQuality = pl[10];
            byte noise = pl[12];
            return new EnvData(temp, hum, light, airQuality, noise);
        }
        log.warn("A1 check sensors received an error: " + Integer.toHexString(err) + " / " + err);
        return null;
    }
}

