/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi;

import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.CmdPayload;
import com.github.mob41.blapi.pkt.Payload;
import java.io.IOException;
import java.net.DatagramPacket;
import javax.xml.bind.DatatypeConverter;

public class SP1Device
extends BLDevice {
    public SP1Device(String host, Mac mac) throws IOException {
        super((short)0, "Smart Plug V1", host, mac);
    }

    public void setPower(final boolean state) throws Exception {
        DatagramPacket packet = this.sendCmdPkt(new CmdPayload(){

            @Override
            public byte getCommand() {
                return 102;
            }

            @Override
            public Payload getPayload() {
                return new Payload(){

                    @Override
                    public byte[] getData() {
                        byte[] b = new byte[4];
                        b[0] = (byte)(state ? 1 : 0);
                        return b;
                    }
                };
            }
        });
        byte[] data = packet.getData();
        log.debug("SP1 set power received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        int err = data[34] | data[35] << 8;
        if (err != 0) {
            log.warn("SP1 set power received returned err: " + Integer.toHexString(err) + " / " + err);
        }
    }
}

