/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi;

import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.CmdPayload;
import com.github.mob41.blapi.pkt.Payload;
import java.io.IOException;
import java.net.DatagramPacket;
import javax.xml.bind.DatatypeConverter;

public class SP2Device
extends BLDevice {
    protected SP2Device(short deviceType, String deviceDesc, String host, Mac mac) throws IOException {
        super(deviceType, deviceDesc, host, mac);
    }

    public SP2Device(String host, Mac mac) throws IOException {
        super((short)10001, "Smart Plug V2", host, mac);
    }

    public void setState(final boolean state) throws Exception {
        DatagramPacket packet = this.sendCmdPkt(new CmdPayload(){

            @Override
            public byte getCommand() {
                return 106;
            }

            @Override
            public Payload getPayload() {
                return new Payload(){

                    @Override
                    public byte[] getData() {
                        byte[] b = new byte[16];
                        b[0] = 2;
                        b[4] = (byte)(state ? 1 : 0);
                        return b;
                    }
                };
            }
        });
        byte[] data = packet.getData();
        log.debug("SP2 set state received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        int err = data[34] | data[35] << 8;
        if (err != 0) {
            log.warn("SP2 set state received returned err: " + Integer.toHexString(err) + " / " + err);
        }
    }

    public boolean getState() throws Exception {
        DatagramPacket packet = this.sendCmdPkt(new CmdPayload(){

            @Override
            public byte getCommand() {
                return 106;
            }

            @Override
            public Payload getPayload() {
                return new Payload(){

                    @Override
                    public byte[] getData() {
                        byte[] b = new byte[16];
                        b[0] = 1;
                        return b;
                    }
                };
            }
        });
        byte[] data = packet.getData();
        log.debug("SP2 get state received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        int err = data[34] | data[35] << 8;
        if (err == 0) {
            byte[] pl = this.decryptFromDeviceMessage(data);
            log.debug("SP2 get state  received bytes (decrypted): " + DatatypeConverter.printHexBinary((byte[])pl));
            return pl[4] == 1;
        }
        log.warn("SP2 get state received an error: " + Integer.toHexString(err) + " / " + err);
        return false;
    }
}

