/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi.dev.hysen;

import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.dev.hysen.AdvancedStatusInfo;
import com.github.mob41.blapi.dev.hysen.AntiFreezing;
import com.github.mob41.blapi.dev.hysen.BaseStatusInfo;
import com.github.mob41.blapi.dev.hysen.LoopMode;
import com.github.mob41.blapi.dev.hysen.Period;
import com.github.mob41.blapi.dev.hysen.PowerOnMemory;
import com.github.mob41.blapi.dev.hysen.SensorControl;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.cmd.hysen.GetBasicInfoCommand;
import com.github.mob41.blapi.pkt.cmd.hysen.GetStatusCommand;
import com.github.mob41.blapi.pkt.cmd.hysen.SetModeCommand;
import com.github.mob41.blapi.pkt.cmd.hysen.SetPeriodsCommand;
import com.github.mob41.blapi.pkt.cmd.hysen.SetPoweCommand;
import com.github.mob41.blapi.pkt.cmd.hysen.SetTempCommand;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;

public class BaseHysenDevice
extends BLDevice {
    protected BaseHysenDevice(short deviceType, String deviceDesc, String host, Mac mac) throws IOException {
        super(deviceType, deviceDesc, host, mac);
    }

    @Override
    public byte[] decryptFromDeviceMessage(byte[] encData) throws Exception {
        return super.decryptFromDeviceMessage(encData);
    }

    public double getThermostatTemp() throws Exception {
        BaseStatusInfo info = this.getBasicStatus();
        return info.getThermostatTemp();
    }

    public double getExternalTemp() throws Exception {
        BaseStatusInfo info = this.getBasicStatus();
        return info.getExternalTemp();
    }

    public double getRoomTemp() throws Exception {
        BaseStatusInfo info = this.getBasicStatus();
        return info.getRoomTemp();
    }

    public BaseStatusInfo getBasicStatus() throws Exception {
        byte[] pl = new GetBasicInfoCommand().execute(this);
        if (pl != null) {
            log.debug("getBasicStatus - received bytes: {}", (Object)DatatypeConverter.printHexBinary((byte[])pl));
            return new BaseStatusInfo(pl);
        }
        return null;
    }

    public AdvancedStatusInfo getAdvancedStatus() throws Exception {
        byte[] pl = new GetStatusCommand().execute(this);
        if (pl != null) {
            log.debug("getAdvancedStatus - received bytes: {}", (Object)DatatypeConverter.printHexBinary((byte[])pl));
            return new AdvancedStatusInfo(pl);
        }
        return null;
    }

    public void setMode(boolean autoMode, LoopMode loopMode, SensorControl sensorControl) throws Exception {
        new SetModeCommand(BaseHysenDevice.tob(autoMode), loopMode.getValue(), sensorControl.getValue()).execute(this);
    }

    public void setMode(boolean autoMode, LoopMode loopMode) throws Exception {
        BaseStatusInfo status = this.getBasicStatus();
        new SetModeCommand(BaseHysenDevice.tob(autoMode), loopMode.getValue(), status.getSensorControl().getValue()).execute(this);
    }

    public void setPower(boolean powerOn, boolean remoteLock) throws Exception {
        new SetPoweCommand(BaseHysenDevice.tob(powerOn), BaseHysenDevice.tob(remoteLock)).execute(this);
    }

    public void setPower(boolean powerOn) throws Exception {
        BaseStatusInfo status = this.getBasicStatus();
        new SetPoweCommand(BaseHysenDevice.tob(powerOn), BaseHysenDevice.tob(status.getRemoteLock())).execute(this);
    }

    public void setLock(boolean remoteLock) throws Exception {
        BaseStatusInfo status = this.getBasicStatus();
        new SetPoweCommand(BaseHysenDevice.tob(status.getPower()), BaseHysenDevice.tob(remoteLock)).execute(this);
    }

    public void setThermostatTemp(double temp) throws Exception {
        new SetTempCommand(temp).execute(this);
    }

    public void switchToAuto() throws Exception {
        BaseStatusInfo status = this.getBasicStatus();
        this.setMode(true, status.getLoopMode(), status.getSensorControl());
    }

    public void switchToManual() throws Exception {
        BaseStatusInfo status = this.getBasicStatus();
        this.setMode(false, status.getLoopMode(), status.getSensorControl());
    }

    public void setAdvancedOptions(LoopMode loopMode, SensorControl sensor, short osv, short dif, short svh, short svl, double adj, AntiFreezing antiFreeze, PowerOnMemory poweron) throws Exception {
        new SetModeCommand(loopMode.getValue(), sensor.getValue(), BaseHysenDevice.tob(osv), BaseHysenDevice.tob(dif), BaseHysenDevice.tob(svh), BaseHysenDevice.tob(svl), adj, antiFreeze.getValue(), poweron.getValue()).execute(this);
    }

    public void setPeriods(Period[] schedule) throws Exception {
        new SetPeriodsCommand(schedule).execute(this);
    }

    private static byte tob(boolean v) {
        return (byte)(v ? 1 : 0);
    }

    private static byte tob(short in) {
        return (byte)(in & 0xFF);
    }
}

