/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi.dev.hysen;

import com.github.mob41.blapi.dev.hysen.AntiFreezing;
import com.github.mob41.blapi.dev.hysen.LoopMode;
import com.github.mob41.blapi.dev.hysen.PowerOnMemory;
import com.github.mob41.blapi.dev.hysen.SensorControl;

public class BaseStatusInfo {
    protected final boolean remoteLock;
    protected final boolean power;
    protected final boolean active;
    protected final boolean manualTemp;
    protected final double roomTemp;
    protected final double thermostatTemp;
    protected final boolean autoMode;
    protected final LoopMode loopMode;
    protected final SensorControl sensorControl;
    protected final short osv;
    protected final short dif;
    protected final short svh;
    protected final short svl;
    protected final double roomTempAdjustment;
    protected final AntiFreezing antiFreezing;
    protected final PowerOnMemory powerOnMemory;
    protected final short fac;
    protected final double externalTemp;

    protected BaseStatusInfo(byte[] payload) {
        this.remoteLock = BaseStatusInfo.byteToBool((byte)(payload[3] & 1));
        this.power = BaseStatusInfo.byteToBool((byte)(payload[4] & 1));
        this.active = BaseStatusInfo.byteToBool((byte)(payload[4] >> 4 & 1));
        this.manualTemp = BaseStatusInfo.byteToBool((byte)(payload[4] >> 6 & 1));
        this.roomTemp = (double)(payload[5] & 0xFF) / 2.0;
        this.thermostatTemp = (double)(payload[6] & 0xFF) / 2.0;
        this.autoMode = BaseStatusInfo.byteToBool((byte)(payload[7] & 0xF));
        this.loopMode = LoopMode.fromValue((byte)((payload[7] >> 4) - 1));
        this.sensorControl = SensorControl.fromValue(payload[8]);
        this.osv = payload[9];
        this.dif = payload[10];
        this.svh = payload[11];
        this.svl = payload[12];
        double tempAdj = (double)((payload[13] << 8) + payload[14]) / 2.0;
        if (tempAdj > 32767.0) {
            tempAdj = 32767.0 - tempAdj;
        }
        this.roomTempAdjustment = tempAdj;
        this.antiFreezing = AntiFreezing.fromValue(payload[15]);
        this.powerOnMemory = PowerOnMemory.fromValue(payload[16]);
        this.fac = payload[17];
        this.externalTemp = (double)(payload[18] & 0xFF) / 2.0;
    }

    public boolean getRemoteLock() {
        return this.remoteLock;
    }

    public boolean getPower() {
        return this.power;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getManualTemp() {
        return this.manualTemp;
    }

    public double getRoomTemp() {
        return this.roomTemp;
    }

    public double getThermostatTemp() {
        return this.thermostatTemp;
    }

    public boolean getAutoMode() {
        return this.autoMode;
    }

    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    public SensorControl getSensorControl() {
        return this.sensorControl;
    }

    public short getOsv() {
        return this.osv;
    }

    public short getDif() {
        return this.dif;
    }

    public short getSvh() {
        return this.svh;
    }

    public short getSvl() {
        return this.svl;
    }

    public double getRoomTempAdjustment() {
        return this.roomTempAdjustment;
    }

    public AntiFreezing getAntiFreezing() {
        return this.antiFreezing;
    }

    public PowerOnMemory getPowerOnMemory() {
        return this.powerOnMemory;
    }

    public short getFac() {
        return this.fac;
    }

    public double getExternalTemp() {
        return this.externalTemp;
    }

    public String toString() {
        return "BaseStatusInfo [\nremote lock=" + this.remoteLock + ",\n power=" + this.power + ",\n active=" + this.active + ",\n manual temp=" + this.manualTemp + ",\n room temp=" + this.roomTemp + ",\n thermostat temp=" + this.thermostatTemp + ",\n auto_mode=" + this.autoMode + ",\n loop_mode=" + (Object)((Object)this.loopMode) + ",\n sensor=" + (Object)((Object)this.sensorControl) + ",\n osv=" + this.osv + ",\n dif=" + this.dif + ",\n svh=" + this.svh + ",\n svl=" + this.svl + ",\n room_temp_adj=" + this.roomTempAdjustment + ",\n anti freeze=" + (Object)((Object)this.antiFreezing) + ",\n powerOnMemory=" + (Object)((Object)this.powerOnMemory) + ",\n fac?=" + this.fac + ",\n external temp=" + this.externalTemp + "]";
    }

    protected static byte boolToByte(boolean v) {
        return (byte)(v ? 1 : 0);
    }

    protected static boolean byteToBool(byte v) {
        return v == 1;
    }
}

